/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.VcsError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitRepository;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitOutgoingCommitsProvider
extends OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> {
    @NotNull
    private final Project myProject;

    public GitOutgoingCommitsProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/push/GitOutgoingCommitsProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public OutgoingResult getOutgoingCommits(@NotNull GitRepository repository, @NotNull PushSpec<GitPushSource, GitPushTarget> pushSpec, boolean initial) {
        OutgoingResult outgoingResult;
        block5: {
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitOutgoingCommitsProvider", "getOutgoingCommits"));
            }
            if (pushSpec == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSpec", "git4idea/push/GitOutgoingCommitsProvider", "getOutgoingCommits"));
            }
            GitLocalBranch branch = ((GitPushSource)pushSpec.getSource()).getBranch();
            String source = branch.equals(repository.getCurrentBranch()) ? "HEAD" : branch.getFullName();
            GitPushTarget target = (GitPushTarget)pushSpec.getTarget();
            String destination = target.getBranch().getFullName();
            try {
                List<GitCommit> commits = !target.isNewBranchCreated() ? GitHistoryUtils.history(this.myProject, repository.getRoot(), destination + ".." + source) : GitHistoryUtils.history(this.myProject, repository.getRoot(), source, "--not", "--remotes=" + target.getBranch().getRemote().getName(), "--max-count=1000");
                outgoingResult = new OutgoingResult(commits, Collections.emptyList());
                if (outgoingResult != null) break block5;
            }
            catch (VcsException e) {
                OutgoingResult outgoingResult2 = new OutgoingResult(Collections.emptyList(), Collections.singletonList(new VcsError(GitUtil.cleanupErrorPrefixes(e.getMessage()))));
                if (outgoingResult2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitOutgoingCommitsProvider", "getOutgoingCommits"));
                }
                return outgoingResult2;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitOutgoingCommitsProvider", "getOutgoingCommits"));
        }
        return outgoingResult;
    }
}

