/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"getParentFunction", "Lcom/intellij/lang/javascript/psi/JSFunction;", "startElement", "Lcom/intellij/psi/PsiElement;", "findTranspiledFile", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "vm", "Lorg/jetbrains/debugger/Vm;", "script", "Lorg/jetbrains/debugger/Script;", "JavaScriptDebugger"})
public final class MemberFilterVisitorKt {
    @NotNull
    public static final Promise<VirtualFile> findTranspiledFile(@NotNull JavaScriptDebuggerViewSupport $receiver, @NotNull Vm vm, @NotNull Script script) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return $receiver.getFileByUrlOrVmSource(vm, script, true);
    }

    private static final JSFunction getParentFunction(PsiElement startElement) {
        if (startElement instanceof PsiFile) {
            return null;
        }
        boolean ignoreJsFun = true;
        for (PsiElement element = startElement.getParent(); element != null; element = element.getParent()) {
            if (element instanceof JSFunction) {
                if (ignoreJsFun) {
                    ignoreJsFun = false;
                    continue;
                }
                return (JSFunction)element;
            }
            if (!(element instanceof JSParameterList) && !(element instanceof JSBlockStatement)) continue;
            ignoreJsFun = false;
        }
        return null;
    }

    @Nullable
    public static final /* synthetic */ JSFunction access$getParentFunction(@NotNull PsiElement startElement) {
        return MemberFilterVisitorKt.getParentFunction(startElement);
    }
}

