/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.EvalScriptVirtualFile;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001e2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0016\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010 \u001a\n !*\u0004\u0018\u00010\u00040\u0004H\u0016J\u0014\u0010\"\u001a\u00020\u00102\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020#0\u001eR<\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/intellij/javascript/debugger/RemoteDebuggingFileFinder;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "mappings", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "parent", "(Lcom/google/common/collect/BiMap;Lcom/intellij/javascript/debugger/DebuggableFileFinder;)V", "<set-?>", "getMappings$JavaScriptDebugger", "()Lcom/google/common/collect/BiMap;", "setMappings", "(Lcom/google/common/collect/BiMap;)V", "getParent$JavaScriptDebugger", "()Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "canSetRemoteUrl", "", "file", "project", "Lcom/intellij/openapi/project/Project;", "findByMappings", "parsedUrl", "Lcom/intellij/util/Url;", "findByName", "url", "filename", "findFile", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "getRemoteUrls", "", "isDebuggable", "toString", "kotlin.jvm.PlatformType", "updateRemoteUrlMapping", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "JavaScriptDebugger"})
public final class RemoteDebuggingFileFinder
implements DebuggableFileFinder {
    @NotNull
    private BiMap<String, VirtualFile> mappings;
    @Nullable
    private final DebuggableFileFinder parent;

    @NotNull
    public final BiMap<String, VirtualFile> getMappings$JavaScriptDebugger() {
        return this.mappings;
    }

    private final void setMappings(BiMap<String, VirtualFile> biMap) {
        this.mappings = biMap;
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile virtualFile = this.findByMappings(url);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            return (Navigatable)JsFileUtil.createNavigatable(project, it);
        }
        DebuggableFileFinder debuggableFileFinder = this.parent;
        if (debuggableFileFinder != null && (debuggableFileFinder = debuggableFileFinder.findNavigatable(url, project)) != null) {
            DebuggableFileFinder debuggableFileFinder2 = debuggableFileFinder;
            Navigatable it = (Navigatable)debuggableFileFinder2;
            return it;
        }
        return (Navigatable)JsFileUtil.createNavigatable(project, this.findByName(url, project));
    }

    private final VirtualFile findByMappings(Url parsedUrl) {
        if (this.mappings.isEmpty()) {
            return null;
        }
        String url = parsedUrl.trimParameters().toDecodedForm();
        int i = url.length();
        while (i != -1) {
            String prefix;
            String string = url;
            int n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, i), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            VirtualFile file = (VirtualFile)this.mappings.get((Object)prefix);
            if (file != null) {
                if (i == url.length()) {
                    return file;
                }
                if (i + 1 == url.length()) {
                    VirtualFile indexFile = BuiltInWebServerKt.findIndexFile((VirtualFile)file);
                    if (indexFile == null) break;
                    return indexFile;
                }
                String string3 = url;
                int n2 = i + 1;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                String filename = string5;
                VirtualFile child = file.findFileByRelativePath(filename);
                if (child == null) break;
                return child;
            }
            i = StringsKt.lastIndexOf$default((CharSequence)url, (char)'/', (int)(i - 1), (boolean)false, (int)4, null);
        }
        return null;
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.findFile(url, project, true);
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project, boolean findByName2) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile virtualFile = this.findByMappings(url);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            return it;
        }
        DebuggableFileFinder debuggableFileFinder = this.parent;
        if (debuggableFileFinder != null && (debuggableFileFinder = debuggableFileFinder.findFile(url, project)) != null) {
            DebuggableFileFinder debuggableFileFinder2 = debuggableFileFinder;
            VirtualFile it = (VirtualFile)debuggableFileFinder2;
            return it;
        }
        return findByName2 ? this.findByName(url, project) : null;
    }

    private final VirtualFile findByName(Url url, Project project) {
        String string;
        if (StringsKt.endsWith$default((CharSequence)url.getPath(), (char)'/', (boolean)false, (int)2, null)) {
            string = "";
        } else {
            String string2 = PathUtilRt.getFileName((String)url.getPath());
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtilRt.getFileName(url.path)");
        }
        return this.findByName(string, project, url);
    }

    private final VirtualFile findByName(String filename, Project project, Url url) {
        List<VirtualFile> files = RemoteDebuggingFileFinderKt.findByName(filename, project);
        if (files == null || files.isEmpty()) {
            return null;
        }
        if (files.size() == 1) {
            return files.get(0);
        }
        VirtualFile virtualFile = files.get(0).getCanonicalFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile canonicalFile = virtualFile;
        int size = files.size();
        for (int i = 1; i < size; ++i) {
            if (!(Intrinsics.areEqual((Object)canonicalFile, (Object)files.get(i).getCanonicalFile()) ^ true)) continue;
            return null;
        }
        if (url == null) {
            return files.get(0);
        }
        String path = url.getPath();
        int offset = 0;
        do {
            for (VirtualFile file : files) {
                String filePath = file.getPath();
                int length = path.length() - offset;
                int n = filePath.length() - length;
                String string = path;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                if (!StringsKt.regionMatches((String)filePath, (int)n, (String)string, (int)offset, (int)length, (boolean)true)) continue;
                return file;
            }
        } while ((offset = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)(offset + 1), (boolean)false, (int)4, null)) >= 0);
        return null;
    }

    public final boolean isDebuggable(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (file instanceof HttpVirtualFile || file instanceof EvalScriptVirtualFile) {
            return true;
        }
        if (!this.mappings.isEmpty()) {
            for (VirtualFile current = file; current != null; current = current.getParent()) {
                if (!this.mappings.containsValue((Object)current)) continue;
                return true;
            }
        }
        if (this.parent instanceof DebuggableFileFinderImpl && ((DebuggableFileFinderImpl)this.parent).isDebuggable(file, project)) {
            return true;
        }
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        return this.findByName(string, project, null) != null;
    }

    @Override
    public boolean canSetRemoteUrl(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file);
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!(file instanceof HttpVirtualFile) && !this.mappings.isEmpty()) {
            BiMap map = this.mappings.inverse();
            for (VirtualFile current = file; current != null; current = current.getParent()) {
                String url = (String)map.get((Object)current);
                if (url == null) continue;
                if (Intrinsics.areEqual((Object)current, (Object)file)) {
                    return CollectionsKt.listOf((Object)Urls.newFromIdea((CharSequence)url));
                }
                return CollectionsKt.listOf((Object)Urls.newFromIdea((CharSequence)(url + "/" + VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)current, (char)'/'))));
            }
        }
        if ((object = this.parent) == null || (object = object.getRemoteUrls(file)) == null) {
            object = CollectionsKt.listOf((Object)Urls.newFromVirtualFile((VirtualFile)file));
        }
        return object;
    }

    public final boolean updateRemoteUrlMapping(@NotNull List<? extends RemoteUrlMappingBean> mappings) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        BiMap<String, VirtualFile> newMap = RemoteDebuggingFileFinderKt.createUrlToLocalMap(mappings);
        if (Intrinsics.areEqual(newMap, this.mappings) ^ true) {
            this.mappings = newMap;
            return true;
        }
        return false;
    }

    public String toString() {
        return Joiner.on((String)"\n ").withKeyValueSeparator("->").join((Map)this.mappings);
    }

    @Nullable
    public final DebuggableFileFinder getParent$JavaScriptDebugger() {
        return this.parent;
    }

    public RemoteDebuggingFileFinder(@NotNull BiMap<String, VirtualFile> mappings, @Nullable DebuggableFileFinder parent) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        this.parent = parent;
        this.mappings = mappings;
    }

    public /* synthetic */ RemoteDebuggingFileFinder(BiMap biMap, DebuggableFileFinder debuggableFileFinder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableBiMap, (String)"ImmutableBiMap.of()");
            biMap = (BiMap)immutableBiMap;
        }
        if ((n & 2) != 0) {
            debuggableFileFinder = null;
        }
        this((BiMap<String, VirtualFile>)biMap, debuggableFileFinder);
    }

    public RemoteDebuggingFileFinder() {
        this(null, null, 3, null);
    }

    @Override
    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return DebuggableFileFinder.DefaultImpls.isOnlySourceMappedBreakpoints(this, file);
    }
}

