/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.plugins.watcher.FwTaskRunner;
import com.intellij.plugins.watcher.TaskRunner;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.util.TaskUtils;
import com.intellij.util.Consumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class FwProjectChangeTracker {
    private static final Logger LOG = Logger.getInstance(FwProjectChangeTracker.class);
    private static final ExtensionPointName<PairProcessor<VirtualFile, Project>> IS_CUSTOM_HANDLER_EP_NAME = ExtensionPointName.create((String)"com.intellij.plugins.watcher.isCustomCondition");
    private static final String VFS_CHANGES_PREFIX = "[tracking vfs changes] ";
    private static final String UNSAVED_DOCUMENTS_PREFIX = "[tracking unsaved documents] ";
    private final Project myProject;
    private MessageBusConnection myConnection;
    private ScheduledFuture myUnsavedDocumentsTrackerFuture;
    private boolean myProjectDisposeHookRegistered;

    public FwProjectChangeTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/FwProjectChangeTracker", "<init>"));
        }
        this.myProject = project;
    }

    public void startTrackingVfsChanges() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myConnection != null || this.myProject.isDefault() || this.myProject.isDisposed()) {
            String message = "[tracking vfs changes] start aborted";
            if (this.myConnection != null) {
                message = message + ": already running";
            }
            LOG.info(message);
            return;
        }
        PathMacros.getInstance().addIgnoredMacro("MESSAGE");
        PathMacros.getInstance().addIgnoredMacro("FILE_PATH");
        PathMacros.getInstance().addIgnoredMacro("LINE");
        PathMacros.getInstance().addIgnoredMacro("COLUMN");
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new FwVirtualFileListener());
        this.myConnection = connection;
        LOG.info("[tracking vfs changes] started");
        this.registerProjectDisposeHook();
    }

    public void stopTrackingVfsChanges() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myConnection != null) {
            LOG.info("[tracking vfs changes] stopped");
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    public void startTrackingUnsavedDocuments() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUnsavedDocumentsTrackerFuture != null || this.myProject.isDefault() || this.myProject.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
            String message = "[tracking unsaved documents] start aborted";
            if (this.myUnsavedDocumentsTrackerFuture != null) {
                message = message + ": already running";
            }
            LOG.info(message);
            return;
        }
        this.myUnsavedDocumentsTrackerFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(new UnsavedDocumentsTracker(), 2L, 2L, TimeUnit.SECONDS);
        LOG.info("[tracking unsaved documents] started");
        this.registerProjectDisposeHook();
    }

    private void registerProjectDisposeHook() {
        if (!this.myProjectDisposeHookRegistered) {
            this.myProjectDisposeHookRegistered = true;
            Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

                public void dispose() {
                    FwProjectChangeTracker.this.stopTrackingVfsChanges();
                    FwProjectChangeTracker.this.stopTrackingUnsavedDocuments();
                }
            });
        }
    }

    public void stopTrackingUnsavedDocuments() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUnsavedDocumentsTrackerFuture != null) {
            LOG.info("[tracking unsaved documents] stopped");
            this.myUnsavedDocumentsTrackerFuture.cancel(false);
            this.myUnsavedDocumentsTrackerFuture = null;
        }
    }

    private boolean needImmediateSync(@NotNull List<TaskOptions> options, @NotNull VirtualFile virtualFile) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/plugins/watcher/FwProjectChangeTracker", "needImmediateSync"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/plugins/watcher/FwProjectChangeTracker", "needImmediateSync"));
        }
        Boolean syntaxErrors = null;
        for (TaskOptions option : options) {
            if (!option.isImmediateSync()) continue;
            if (!option.isCheckSyntaxErrors()) {
                return true;
            }
            if (syntaxErrors == null) {
                syntaxErrors = PsiErrorElementUtil.hasErrors((Project)this.myProject, (VirtualFile)virtualFile);
            }
            if (syntaxErrors.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private class UnsavedDocumentsTracker
    implements Runnable {
        private UnsavedDocumentsTracker() {
        }

        @Override
        public void run() {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Document[] unsavedDocuments = fileDocumentManager.getUnsavedDocuments();
            List documentsToSave = null;
            for (Document unsavedDocument : unsavedDocuments) {
                if (!this.shouldSave(unsavedDocument, fileDocumentManager)) continue;
                if (documentsToSave == null) {
                    documentsToSave = ContainerUtil.newArrayListWithCapacity((int)unsavedDocuments.length);
                }
                documentsToSave.add(unsavedDocument);
            }
            if (documentsToSave != null) {
                this.batchSave((ImmutableList<Document>)ImmutableList.copyOf(documentsToSave), fileDocumentManager);
            }
        }

        private void batchSave(@NotNull ImmutableList<Document> documentsToSave, @NotNull FileDocumentManager fileDocumentManager) {
            if (documentsToSave == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentsToSave", "com/intellij/plugins/watcher/FwProjectChangeTracker$UnsavedDocumentsTracker", "batchSave"));
            }
            if (fileDocumentManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDocumentManager", "com/intellij/plugins/watcher/FwProjectChangeTracker$UnsavedDocumentsTracker", "batchSave"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (documentsToSave == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentsToSave", "com/intellij/plugins/watcher/FwProjectChangeTracker$UnsavedDocumentsTracker", "lambda$batchSave$0"));
                }
                if (fileDocumentManager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDocumentManager", "com/intellij/plugins/watcher/FwProjectChangeTracker$UnsavedDocumentsTracker", "lambda$batchSave$0"));
                }
                for (Document document : documentsToSave) {
                    fileDocumentManager.saveDocument(document);
                }
            }, FwProjectChangeTracker.this.myProject.getDisposed());
        }

        private boolean shouldSave(@NotNull Document document, @NotNull FileDocumentManager fileDocumentManager) {
            List<TaskOptions> options;
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/plugins/watcher/FwProjectChangeTracker$UnsavedDocumentsTracker", "shouldSave"));
            }
            if (fileDocumentManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDocumentManager", "com/intellij/plugins/watcher/FwProjectChangeTracker$UnsavedDocumentsTracker", "shouldSave"));
            }
            VirtualFile file = fileDocumentManager.getFile(document);
            if (file == null) {
                return false;
            }
            ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)FwProjectChangeTracker.this.myProject);
            if (!index.isInContent(file)) {
                return false;
            }
            for (PairProcessor isCustom : (PairProcessor[])IS_CUSTOM_HANDLER_EP_NAME.getExtensions()) {
                if (!isCustom.process((Object)file, (Object)FwProjectChangeTracker.this.myProject)) continue;
                return false;
            }
            LookupEx activeLookup = LookupManager.getInstance((Project)FwProjectChangeTracker.this.myProject).getActiveLookup();
            if (activeLookup != null && activeLookup.isCompletion()) {
                return false;
            }
            return !DumbService.isDumb((Project)FwProjectChangeTracker.this.myProject) && FwProjectChangeTracker.this.needImmediateSync(options = ProjectTasksOptions.getInstance(FwProjectChangeTracker.this.myProject).findTasksForFile(file), file);
        }
    }

    private class FwVirtualFileListener
    extends VirtualFileAdapter
    implements BulkFileListener {
        private QueueProcessor<Runnable> myQueueProcessor = QueueProcessor.createRunnableQueueProcessor((QueueProcessor.ThreadToUse)QueueProcessor.ThreadToUse.POOLED);

        private FwVirtualFileListener() {
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "beforeContentsChange"));
            }
            VirtualFile file = event.getFile();
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            if (fileDocumentManager.isFileModified(file) && TaskUtils.isGenerated(file)) {
                fileDocumentManager.reloadFiles(new VirtualFile[]{file});
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "contentsChanged"));
            }
            this.scheduleTask(FwProjectChangeTracker.this.myProject, event.getFile(), (Consumer<VirtualFile>)((Consumer)file -> FwTaskRunner.tryFindTasksAndRun(FwProjectChangeTracker.this.myProject, file)));
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "propertyChanged"));
            }
            if ("name".equals(event.getPropertyName())) {
                boolean same = ComparatorUtil.equalsNullable((Object)event.getOldValue(), (Object)event.getNewValue());
                if (same) {
                    return;
                }
                this.scheduleTask(FwProjectChangeTracker.this.myProject, event.getFile(), (Consumer<VirtualFile>)((Consumer)file -> {
                    if (!TaskUtils.isGenerated(file)) {
                        FwTaskRunner.tryFindTasksAndRun(FwProjectChangeTracker.this.myProject, file);
                    }
                }));
            }
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "fileCreated"));
            }
            this.scheduleTask(FwProjectChangeTracker.this.myProject, event.getFile(), (Consumer<VirtualFile>)((Consumer)file -> {
                if (file.isDirectory()) {
                    ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)FwProjectChangeTracker.this.myProject);
                    index.iterateContentUnderDirectory(file, new ContentIterator(){

                        public boolean processFile(VirtualFile descendant) {
                            if (!descendant.isDirectory()) {
                                FwVirtualFileListener.this.tryFindTaskAndRunForCreatedFile(descendant);
                            }
                            return !FwProjectChangeTracker.this.myProject.isDisposed();
                        }
                    });
                } else {
                    this.tryFindTaskAndRunForCreatedFile((VirtualFile)file);
                }
            }));
        }

        private void scheduleTask(@NotNull Project project, @NotNull VirtualFile file, @NotNull Consumer<VirtualFile> task) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "scheduleTask"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "scheduleTask"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "scheduleTask"));
            }
            this.myQueueProcessor.add(() -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "lambda$scheduleTask$3"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "lambda$scheduleTask$3"));
                }
                if (task == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "lambda$scheduleTask$3"));
                }
                if (file.isValid() && !project.isDisposed()) {
                    task.consume((Object)file);
                }
            });
        }

        private void tryFindTaskAndRunForCreatedFile(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "tryFindTaskAndRunForCreatedFile"));
            }
            if (!TaskRunner.getInstance().inRefreshState(file.getUrl()) && file.isValid() && !TaskUtils.isGenerated(file)) {
                FwTaskRunner.tryFindTasksAndRun(FwProjectChangeTracker.this.myProject, file);
            }
        }

        public void before(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "before"));
            }
            for (VFileEvent vFileEvent : events) {
                BulkVirtualFileListenerAdapter.fireBefore((VirtualFileListener)this, (VFileEvent)vFileEvent);
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener", "after"));
            }
            for (VFileEvent vFileEvent : events) {
                BulkVirtualFileListenerAdapter.fireAfter((VirtualFileListener)this, (VFileEvent)vFileEvent);
            }
        }
    }
}

