/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDependencyFinder {
    public static final ExtensionPointName<FileDependencyFinder> EP_NAME = ExtensionPointName.create((String)"com.intellij.plugins.watcher.dependency.finder");
    private static final QueueProcessor<Runnable> QUEUE_PROCESSOR = QueueProcessor.createRunnableQueueProcessor((QueueProcessor.ThreadToUse)QueueProcessor.ThreadToUse.POOLED);

    public abstract boolean accept(@Nullable String var1);

    public boolean trackAllDependentFiles() {
        return true;
    }

    public boolean updateGeneratedFilesOfDependencies() {
        return false;
    }

    @NotNull
    public Set<VirtualFile> findDependentFiles(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/config/FileDependencyFinder", "findDependentFiles"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/plugins/watcher/config/FileDependencyFinder", "findDependentFiles"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/plugins/watcher/config/FileDependencyFinder", "findDependentFiles"));
        }
        if (DumbService.isDumb((Project)project)) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/config/FileDependencyFinder", "findDependentFiles"));
            }
            return set;
        }
        if (!virtualFile.isValid()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/config/FileDependencyFinder", "findDependentFiles"));
            }
            return set;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/config/FileDependencyFinder", "findDependentFiles"));
            }
            return set;
        }
        THashSet result = new THashSet();
        FileIncludeManager.getManager((Project)project).processIncludingFiles(psiFile, arg_0 -> FileDependencyFinder.lambda$findDependentFiles$0(scope, (Set)result, arg_0));
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/config/FileDependencyFinder", "findDependentFiles"));
        }
        return tHashSet;
    }

    public void findDependenciesAsync(@NotNull Project project, @NotNull VirtualFile file, @NotNull GlobalSearchScope scope, boolean recursively, @NotNull Consumer<Set<VirtualFile>> dependenciesConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/config/FileDependencyFinder", "findDependenciesAsync"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/config/FileDependencyFinder", "findDependenciesAsync"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/plugins/watcher/config/FileDependencyFinder", "findDependenciesAsync"));
        }
        if (dependenciesConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesConsumer", "com/intellij/plugins/watcher/config/FileDependencyFinder", "findDependenciesAsync"));
        }
        DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$findDependenciesAsync$3"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$findDependenciesAsync$3"));
            }
            if (dependenciesConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesConsumer", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$findDependenciesAsync$3"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$findDependenciesAsync$3"));
            }
            QUEUE_PROCESSOR.add(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$null$2"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$null$2"));
                }
                if (dependenciesConsumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesConsumer", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$null$2"));
                }
                if (scope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$null$2"));
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$null$1"));
                    }
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$null$1"));
                    }
                    if (dependenciesConsumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesConsumer", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$null$1"));
                    }
                    if (scope == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$null$1"));
                    }
                    if (project.isDisposed() || !file.isValid()) {
                        dependenciesConsumer.consume(Collections.emptySet());
                        return;
                    }
                    VirtualFile[] dependencyArray = FileIncludeManager.getManager((Project)project).getIncludedFiles(file, true, recursively);
                    if (dependencyArray == null || dependencyArray.length == 0) {
                        dependenciesConsumer.consume(Collections.emptySet());
                        return;
                    }
                    THashSet result = new THashSet(dependencyArray.length);
                    for (VirtualFile dependency : dependencyArray) {
                        if (!scope.accept(dependency)) continue;
                        result.add(dependency);
                    }
                    dependenciesConsumer.consume((Object)result);
                });
            });
        }, ModalityState.any());
    }

    private static /* synthetic */ boolean lambda$findDependentFiles$0(@NotNull GlobalSearchScope scope, Set result, Pair pair) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/plugins/watcher/config/FileDependencyFinder", "lambda$findDependentFiles$0"));
        }
        VirtualFile file = (VirtualFile)pair.getFirst();
        if (scope.contains(file)) {
            result.add(file);
        }
        return true;
    }
}

