/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.Pair;
import com.intellij.plugins.watcher.model.TaskOptions;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileWatchersState {
    private final List<Pair<TaskOptions, Boolean>> myTasks;
    private final ImmutableList<String> mySuppressedTaskNames;

    public FileWatchersState(@NotNull List<Pair<TaskOptions, Boolean>> tasks, @NotNull List<String> suppressedTaskNames) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/plugins/watcher/config/FileWatchersState", "<init>"));
        }
        if (suppressedTaskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suppressedTaskNames", "com/intellij/plugins/watcher/config/FileWatchersState", "<init>"));
        }
        this.myTasks = tasks;
        this.mySuppressedTaskNames = ImmutableList.copyOf(suppressedTaskNames);
    }

    @NotNull
    public List<Pair<TaskOptions, Boolean>> getTasks() {
        List<Pair<TaskOptions, Boolean>> list = this.myTasks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/config/FileWatchersState", "getTasks"));
        }
        return list;
    }

    @NotNull
    public ImmutableList<String> getSuppressedTaskNames() {
        ImmutableList<String> immutableList = this.mySuppressedTaskNames;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/config/FileWatchersState", "getSuppressedTaskNames"));
        }
        return immutableList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileWatchersState state = (FileWatchersState)o;
        return this.myTasks.equals(state.myTasks) && this.mySuppressedTaskNames.equals(state.mySuppressedTaskNames);
    }

    public int hashCode() {
        int result = this.myTasks.hashCode();
        result = 31 * result + this.mySuppressedTaskNames.hashCode();
        return result;
    }
}

