/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.FileWatchersState;
import com.intellij.plugins.watcher.config.ui.WatchersPanel;
import com.intellij.plugins.watcher.model.ApplicationTasksOptions;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.ui.EditorNotifications;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchersConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private WatchersPanel myPanel;

    public WatchersConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/config/WatchersConfigurable", "<init>"));
        }
        this.myProject = project;
    }

    public String getDisplayName() {
        return BackgroundTaskBundle.message("settings.name", new Object[0]);
    }

    @NotNull
    public String getId() {
        if ("watcher.settings" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/config/WatchersConfigurable", "getId"));
        }
        return "watcher.settings";
    }

    public String getHelpTopic() {
        return "settings.project.settings.file.watchers";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new WatchersPanel(this.myProject);
        }
        return this.myPanel.getComponent();
    }

    public WatchersPanel getPanel() {
        this.createComponent();
        return this.myPanel;
    }

    public boolean isModified() {
        FileWatchersState savedState;
        if (this.myPanel == null) {
            return false;
        }
        FileWatchersState uiState = this.myPanel.getState();
        return !uiState.equals(savedState = ProjectTasksOptions.getInstance(this.myProject).getWatchersState());
    }

    public void apply() throws ConfigurationException {
        if (this.myPanel != null) {
            FileWatchersState state = this.myPanel.getState();
            ProjectTasksOptions.getInstance(this.myProject).setWatchersState(state);
            ApplicationTasksOptions.getInstance().addOrUpdate(state.getTasks());
            EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        }
    }

    public void reset() {
        if (this.myPanel != null) {
            FileWatchersState savedState = ProjectTasksOptions.getInstance(this.myProject).getWatchersState();
            this.myPanel.reset(savedState);
        }
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }
}

