/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.model;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.model.TasksPersistentComponent;
import gnu.trove.THashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ApplicationTasksOptions", storages={@Storage(value="watcherDefaultTasks.xml")})
public class ApplicationTasksOptions
extends TasksPersistentComponent {
    public static ApplicationTasksOptions getInstance() {
        return (ApplicationTasksOptions)ServiceManager.getService(ApplicationTasksOptions.class);
    }

    public void addOrUpdate(List<Pair<TaskOptions, Boolean>> tasks) {
        THashMap map2index = new THashMap();
        List<Pair<TaskOptions, Boolean>> myTasks = this.getTasks();
        for (int i = 0; i < myTasks.size(); ++i) {
            Pair<TaskOptions, Boolean> optionsPair = myTasks.get(i);
            map2index.put(((TaskOptions)optionsPair.getFirst()).getName(), i);
        }
        for (Pair<TaskOptions, Boolean> optionsPair : tasks) {
            TaskOptions options = (TaskOptions)optionsPair.getFirst();
            Integer index = (Integer)map2index.get(options.getName());
            if (index == null) {
                map2index.put(options.getName(), myTasks.size());
                myTasks.add(optionsPair);
                continue;
            }
            myTasks.set(index, optionsPair);
        }
    }

    @Override
    @NotNull
    public List<String> getSuppressedTaskNames() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/ApplicationTasksOptions", "getSuppressedTaskNames"));
        }
        return immutableList;
    }

    @Override
    public void setSuppressedTaskNames(@NotNull List<String> suppressedTaskNames) {
        if (suppressedTaskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suppressedTaskNames", "com/intellij/plugins/watcher/model/ApplicationTasksOptions", "setSuppressedTaskNames"));
        }
    }
}

