/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.model;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.FileTypeBackgroundTaskConsumer;
import com.intellij.plugins.watcher.problems.FwOutputSettings;
import com.intellij.plugins.watcher.util.TaskUtils;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.tools.FilterInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskOptions {
    private String name;
    private String description;
    private String myProgram;
    private String myArguments;
    private String myWorkingDir;
    private boolean myCheckSyntaxErrors = true;
    private boolean myImmediateSync = true;
    private boolean myTrackOnlyRoot = true;
    private boolean myOutputFromStdout = false;
    private String myScopeName;
    private String myFileExtension;
    private String myOutput;
    private ExitCodeBehavior myExitCodeBehavior = ExitCodeBehavior.ERROR;
    private EnvironmentVariablesData myEnvData = EnvironmentVariablesData.DEFAULT;
    private FilterInfo[] myOutputFilters = new FilterInfo[0];

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProgram() {
        return this.myProgram;
    }

    public void setProgram(String program) {
        this.myProgram = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)program));
    }

    public void setArguments(String arguments) {
        this.myArguments = arguments;
    }

    public String getArguments() {
        return this.myArguments;
    }

    public void setWorkingDir(String workingDir) {
        this.myWorkingDir = workingDir == null ? null : FileUtil.toSystemIndependentName((String)workingDir);
    }

    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public void setTrackOnlyRoot(boolean trackOnlyRoot) {
        this.myTrackOnlyRoot = trackOnlyRoot;
    }

    public boolean isTrackOnlyRoot() {
        return this.myTrackOnlyRoot;
    }

    public void setScopeName(String scopeName) {
        this.myScopeName = scopeName;
    }

    public String getScopeName() {
        return this.myScopeName;
    }

    public void setFileExtension(String fileMask) {
        this.myFileExtension = fileMask;
    }

    @Nullable
    public String getFileExtension() {
        return this.myFileExtension;
    }

    public void setOutput(String output) {
        this.myOutput = output;
    }

    public String getOutput() {
        return this.myOutput;
    }

    public boolean isOutputFromStdout() {
        return this.myOutputFromStdout;
    }

    public void setOutputFromStdout(boolean outputFromStdout) {
        this.myOutputFromStdout = outputFromStdout;
    }

    public void setEnvData(@NotNull EnvironmentVariablesData envData) {
        if (envData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/plugins/watcher/model/TaskOptions", "setEnvData"));
        }
        this.myEnvData = envData;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/TaskOptions", "getEnvData"));
        }
        return environmentVariablesData;
    }

    public FilterInfo[] getOutputFilters() {
        return this.myOutputFilters;
    }

    public void setOutputFilters(FilterInfo[] outputFilters) {
        this.myOutputFilters = outputFilters;
    }

    @NotNull
    public ExitCodeBehavior getExitCodeBehavior() {
        ExitCodeBehavior exitCodeBehavior = this.myExitCodeBehavior;
        if (exitCodeBehavior == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/TaskOptions", "getExitCodeBehavior"));
        }
        return exitCodeBehavior;
    }

    public void setExitCodeBehavior(@NotNull ExitCodeBehavior exitCodeBehavior) {
        if (exitCodeBehavior == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exitCodeBehavior", "com/intellij/plugins/watcher/model/TaskOptions", "setExitCodeBehavior"));
        }
        this.myExitCodeBehavior = exitCodeBehavior;
    }

    public boolean isCheckSyntaxErrors() {
        return this.myCheckSyntaxErrors;
    }

    public void setCheckSyntaxErrors(boolean checkSyntaxErrors) {
        this.myCheckSyntaxErrors = checkSyntaxErrors;
    }

    public boolean isImmediateSync() {
        return this.myImmediateSync;
    }

    public void setImmediateSync(boolean immediateSync) {
        this.myImmediateSync = immediateSync;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskOptions options = (TaskOptions)o;
        if (this.myOutputFromStdout != options.myOutputFromStdout) {
            return false;
        }
        if (this.myTrackOnlyRoot != options.myTrackOnlyRoot) {
            return false;
        }
        if (this.myCheckSyntaxErrors != options.myCheckSyntaxErrors) {
            return false;
        }
        if (this.myImmediateSync != options.myImmediateSync) {
            return false;
        }
        if (!Comparing.equal((String)this.description, (String)options.description)) {
            return false;
        }
        if (!Comparing.equal((String)this.myArguments, (String)options.myArguments)) {
            return false;
        }
        if (!this.myEnvData.equals((Object)options.myEnvData)) {
            return false;
        }
        if (this.myExitCodeBehavior != options.myExitCodeBehavior) {
            return false;
        }
        if (!Comparing.equal((String)this.myFileExtension, (String)options.myFileExtension)) {
            return false;
        }
        if (!Comparing.equal((String)this.myOutput, (String)options.myOutput)) {
            return false;
        }
        if (!Arrays.equals(this.myOutputFilters, options.myOutputFilters)) {
            return false;
        }
        if (!Comparing.equal((String)this.myProgram, (String)options.myProgram)) {
            return false;
        }
        if (!Comparing.equal((String)this.myScopeName, (String)options.myScopeName)) {
            return false;
        }
        if (!Comparing.equal((String)this.myWorkingDir, (String)options.myWorkingDir)) {
            return false;
        }
        return Comparing.equal((String)this.name, (String)options.name);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.myProgram != null ? this.myProgram.hashCode() : 0);
        result = 31 * result + (this.myArguments != null ? this.myArguments.hashCode() : 0);
        result = 31 * result + (this.myWorkingDir != null ? this.myWorkingDir.hashCode() : 0);
        result = 31 * result + (this.myCheckSyntaxErrors ? 1 : 0);
        result = 31 * result + (this.myImmediateSync ? 1 : 0);
        result = 31 * result + (this.myTrackOnlyRoot ? 1 : 0);
        result = 31 * result + (this.myOutputFromStdout ? 1 : 0);
        result = 31 * result + (this.myScopeName != null ? this.myScopeName.hashCode() : 0);
        result = 31 * result + (this.myFileExtension != null ? this.myFileExtension.hashCode() : 0);
        result = 31 * result + (this.myOutput != null ? this.myOutput.hashCode() : 0);
        result = 31 * result + (this.myExitCodeBehavior != null ? this.myExitCodeBehavior.hashCode() : 0);
        result = 31 * result + this.myEnvData.hashCode();
        result = 31 * result + (this.myOutputFilters != null ? Arrays.hashCode(this.myOutputFilters) : 0);
        return result;
    }

    public TaskOptions createCopy() {
        TaskOptions result = new TaskOptions();
        result.setName(this.name);
        result.setDescription(this.description);
        result.setProgram(this.myProgram);
        result.setArguments(this.myArguments);
        result.setWorkingDir(this.myWorkingDir);
        result.setCheckSyntaxErrors(this.myCheckSyntaxErrors);
        result.setImmediateSync(this.myImmediateSync);
        result.setTrackOnlyRoot(this.myTrackOnlyRoot);
        result.setOutputFromStdout(this.myOutputFromStdout);
        result.setScopeName(this.myScopeName);
        result.setFileExtension(this.myFileExtension);
        result.setOutput(this.myOutput);
        result.setExitCodeBehavior(this.myExitCodeBehavior);
        result.setEnvData(this.myEnvData);
        FilterInfo[] filterInfos = new FilterInfo[this.myOutputFilters.length];
        for (int i = 0; i < this.myOutputFilters.length; ++i) {
            filterInfos[i] = this.myOutputFilters[i].createCopy();
        }
        result.setOutputFilters(filterInfos);
        return result;
    }

    public String toString() {
        return "TaskOptions{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", myProgram='" + this.myProgram + '\'' + ", myArguments='" + this.myArguments + '\'' + ", myWorkingDir='" + this.myWorkingDir + '\'' + ", myCheckSyntaxErrors=" + this.myCheckSyntaxErrors + ", myImmediateSync=" + this.myImmediateSync + ", myTrackOnlyRoot=" + this.myTrackOnlyRoot + ", myOutputFromStdout=" + this.myOutputFromStdout + ", myScopeName='" + this.myScopeName + '\'' + ", myFileExtension='" + this.myFileExtension + '\'' + ", myOutput='" + this.myOutput + '\'' + ", myExitCodeBehavior=" + (Object)((Object)this.myExitCodeBehavior) + '}';
    }

    @NotNull
    public GlobalSearchScope getFileScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/model/TaskOptions", "getFileScope"));
        }
        GlobalSearchScope scope = ScopeChooserUtils.findScopeByName((Project)project, (String)this.myScopeName);
        GlobalSearchScope globalSearchScope = scope.intersectWith((GlobalSearchScope)new FileTypeScope());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/TaskOptions", "getFileScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public FileType getFileType() {
        FileType typeByExtension;
        if (StringUtil.isEmpty((String)this.myFileExtension)) {
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/TaskOptions", "getFileType"));
            }
            return fileType;
        }
        if (TaskUtils.FAKE_ANY_FILE_TYPE.getDefaultExtension().equalsIgnoreCase(this.myFileExtension)) {
            FileType fileType = TaskUtils.FAKE_ANY_FILE_TYPE;
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/TaskOptions", "getFileType"));
            }
            return fileType;
        }
        String extension = this.myFileExtension;
        int index = extension.indexOf(59);
        if (index > 0) {
            extension = extension.substring(0, index);
        }
        if ((typeByExtension = FileTypeManager.getInstance().getFileTypeByExtension(extension)) != UnknownFileType.INSTANCE) {
            FileType fileType = typeByExtension;
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/TaskOptions", "getFileType"));
            }
            return fileType;
        }
        FileType typeByName = (FileType)ContainerUtil.find((Object[])FileTypeManager.getInstance().getRegisteredFileTypes(), type -> this.myFileExtension.equalsIgnoreCase(type.getName()));
        FileType fileType = typeByName == null ? UnknownFileType.INSTANCE : typeByName;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/TaskOptions", "getFileType"));
        }
        return fileType;
    }

    @NotNull
    public FwOutputSettings getOutputSettings() {
        FileType fileType = this.getFileType();
        FileTypeBackgroundTaskConsumer taskConsumer = BackgroundTaskConsumer.findConsumerByFileType(fileType);
        FwOutputSettings outputSettings = null;
        if (taskConsumer != null) {
            outputSettings = taskConsumer.getOutputSettings();
        }
        FwOutputSettings fwOutputSettings = (FwOutputSettings)ObjectUtils.notNull((Object)outputSettings, (Object)FwOutputSettings.DEFAULT);
        if (fwOutputSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/TaskOptions", "getOutputSettings"));
        }
        return fwOutputSettings;
    }

    private class FileTypeScope
    extends GlobalSearchScope {
        private FileTypeScope() {
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/model/TaskOptions$FileTypeScope", "contains"));
            }
            FileType fileType = TaskOptions.this.getFileType();
            if (fileType == TaskUtils.FAKE_ANY_FILE_TYPE) {
                return true;
            }
            if (fileType == UnknownFileType.INSTANCE) {
                return false;
            }
            return file.getFileType() == fileType;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/plugins/watcher/model/TaskOptions$FileTypeScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/plugins/watcher/model/TaskOptions$FileTypeScope", "compare"));
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/plugins/watcher/model/TaskOptions$FileTypeScope", "isSearchInModuleContent"));
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }
    }

    public static enum ExitCodeBehavior {
        ALWAYS("Always"),
        ERROR("Error"),
        NEVER("Never");

        private final String myDisplayName;

        private ExitCodeBehavior(String name) {
            this.myDisplayName = name;
        }

        public String getDisplayName() {
            return this.myDisplayName;
        }
    }
}

