/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.model;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.watcher.config.FileWatchersState;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TasksPersistentComponent
implements PersistentStateComponent<Element> {
    private final List<Pair<TaskOptions, Boolean>> myTasks = new CopyOnWriteArrayList<Pair<TaskOptions, Boolean>>();
    public static final String TASK_OPTIONS = "TaskOptions";
    public static final String TASK_ENABLED = "isEnabled";
    private static final String SUPPRESSED_TASK_NAMES = "suppressed-tasks";

    @NotNull
    public List<Pair<TaskOptions, Boolean>> getTasks() {
        List<Pair<TaskOptions, Boolean>> list = this.myTasks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/TasksPersistentComponent", "getTasks"));
        }
        return list;
    }

    public void setTasks(List<Pair<TaskOptions, Boolean>> tasks) {
        this.myTasks.clear();
        this.myTasks.addAll(tasks);
    }

    @Nullable
    public Element getState() {
        return TasksPersistentComponent.getElement(this.getTasks(), this.getSuppressedTaskNames());
    }

    @NotNull
    public abstract List<String> getSuppressedTaskNames();

    public abstract void setSuppressedTaskNames(@NotNull List<String> var1);

    @NotNull
    public static Element getElement(List<Pair<TaskOptions, Boolean>> tasks, @NotNull List<String> suppressedTaskNames) {
        if (suppressedTaskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suppressedTaskNames", "com/intellij/plugins/watcher/model/TasksPersistentComponent", "getElement"));
        }
        Element element = new Element(TASK_OPTIONS);
        for (Pair<TaskOptions, Boolean> task : tasks) {
            Element taskElement = XmlSerializer.serialize((Object)task.getFirst(), (SerializationFilter)new SerializationFilter(){

                public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
                    if (accessor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/plugins/watcher/model/TasksPersistentComponent$1", "accepts"));
                    }
                    if (bean == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/plugins/watcher/model/TasksPersistentComponent$1", "accepts"));
                    }
                    return accessor.getGenericType() != EnvironmentVariablesData.class;
                }
            });
            ((TaskOptions)task.getFirst()).getEnvData().writeExternal(taskElement);
            if (task.getSecond() != null) {
                taskElement.setAttribute(TASK_ENABLED, Boolean.toString((Boolean)task.getSecond()));
            }
            element.addContent(taskElement);
        }
        if (!suppressedTaskNames.isEmpty()) {
            String allSuppressedTaskNames = StringUtil.join(suppressedTaskNames, (String)";");
            element.setAttribute(SUPPRESSED_TASK_NAMES, allSuppressedTaskNames);
        }
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/TasksPersistentComponent", "getElement"));
        }
        return element2;
    }

    public void loadState(Element element) {
        FileWatchersState state = TasksPersistentComponent.getTaskOptions(element);
        this.setTasks(state.getTasks());
        this.setSuppressedTaskNames((List<String>)state.getSuppressedTaskNames());
    }

    @NotNull
    public static FileWatchersState getTaskOptions(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/plugins/watcher/model/TasksPersistentComponent", "getTaskOptions"));
        }
        ArrayList<Pair<TaskOptions, Boolean>> tasks = new ArrayList<Pair<TaskOptions, Boolean>>();
        for (Object item : state.getChildren(TASK_OPTIONS)) {
            Element element = (Element)item;
            TaskOptions options = (TaskOptions)XmlSerializer.deserialize((Element)element, TaskOptions.class);
            EnvironmentVariablesData envData = EnvironmentVariablesData.readExternal((Element)element);
            options.setEnvData(envData);
            tasks.add((Pair<TaskOptions, Boolean>)Pair.create((Object)options, (Object)Boolean.parseBoolean(element.getAttributeValue(TASK_ENABLED))));
        }
        List suppressedTaskNames = Collections.emptyList();
        String suppressedTaskNamesStr = state.getAttributeValue(SUPPRESSED_TASK_NAMES);
        if (!StringUtil.isEmptyOrSpaces((String)suppressedTaskNamesStr)) {
            suppressedTaskNames = StringUtil.split((String)suppressedTaskNamesStr, (String)";");
        }
        FileWatchersState fileWatchersState = new FileWatchersState(tasks, suppressedTaskNames);
        if (fileWatchersState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/TasksPersistentComponent", "getTaskOptions"));
        }
        return fileWatchersState;
    }

    @Nullable
    public Pair<TaskOptions, Boolean> findTaskByName(String name) {
        return (Pair)ContainerUtil.find(this.getTasks(), pair -> name.equalsIgnoreCase(((TaskOptions)pair.getFirst()).getName()));
    }

    public void setEnabledForTask(String name, boolean isEnabled) {
        List<Pair<TaskOptions, Boolean>> oldTasks = this.getTasks();
        int size = oldTasks.size();
        ArrayList<Pair<TaskOptions, Boolean>> newTasks = new ArrayList<Pair<TaskOptions, Boolean>>(size);
        for (Pair<TaskOptions, Boolean> pair : oldTasks) {
            TaskOptions options = (TaskOptions)pair.getFirst();
            if (name.equals(options.getName())) {
                newTasks.add((Pair<TaskOptions, Boolean>)Pair.create((Object)options, (Object)isEnabled));
                continue;
            }
            newTasks.add(pair);
        }
        this.setTasks(newTasks);
    }

    public void addTask(TaskOptions options, boolean isEnabled) {
        this.getTasks().add((Pair<TaskOptions, Boolean>)Pair.create((Object)options, (Object)isEnabled));
    }
}

