/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.util;

import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.FileDependencyFinder;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskUtils {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)BackgroundTaskBundle.message("settings.name", new Object[0]));
    private static final FileAttribute CREATED_BY_ATTRIBUTE = new FileAttribute("file.watcher", 1, false);
    public static final FileType FAKE_ANY_FILE_TYPE = new FileType(){

        @NotNull
        public String getName() {
            if ("Any" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/util/TaskUtils$1", "getName"));
            }
            return "Any";
        }

        @NotNull
        public String getDescription() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/util/TaskUtils$1", "getDescription"));
            }
            return string;
        }

        @NotNull
        public String getDefaultExtension() {
            if ("*" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/util/TaskUtils$1", "getDefaultExtension"));
            }
            return "*";
        }

        @Nullable
        public Icon getIcon() {
            return AllIcons.FileTypes.Any_type;
        }

        public boolean isBinary() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        @Nullable
        public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/util/TaskUtils$1", "getCharset"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/plugins/watcher/util/TaskUtils$1", "getCharset"));
            }
            return null;
        }
    };

    public static boolean isGenerated(@Nullable VirtualFile file) {
        return !StringUtil.isEmpty((String)TaskUtils.extractCreatedTaskName(file));
    }

    @Nullable
    public static String extractCreatedTaskName(@Nullable VirtualFile file) {
        Pair<String, String> taskInfo = TaskUtils.extractTaskInfo(file);
        return taskInfo != null ? (String)taskInfo.getFirst() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Pair<String, String> extractTaskInfo(@Nullable VirtualFile file) {
        Pair pair;
        block7: {
            if (!(file instanceof NewVirtualFile) || !file.isValid()) {
                return null;
            }
            DataInputStream inputStream = CREATED_BY_ATTRIBUTE.readAttribute(file);
            try {
                String watcherName = inputStream != null ? inputStream.readUTF() : null;
                String originalFileName = inputStream != null ? inputStream.readUTF() : null;
                Pair pair2 = pair = StringUtil.isEmpty((String)watcherName) ? null : Pair.create((Object)watcherName, (Object)originalFileName);
                if (inputStream == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            inputStream.close();
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveOutputFileInfo(@NotNull VirtualFile outputFile, @Nullable String watcherName, @NotNull VirtualFile sourceFile) {
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "com/intellij/plugins/watcher/util/TaskUtils", "saveOutputFileInfo"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/plugins/watcher/util/TaskUtils", "saveOutputFileInfo"));
        }
        if (!(outputFile instanceof NewVirtualFile)) {
            return;
        }
        if (sourceFile.equals(outputFile)) {
            return;
        }
        boolean sameParent = sourceFile.getParent() != null && sourceFile.getParent().equals(outputFile.getParent());
        String sourceFileName = sameParent ? sourceFile.getName() : null;
        DataOutputStream outputStream = CREATED_BY_ATTRIBUTE.writeAttribute(outputFile);
        try {
            try {
                outputStream.writeUTF(StringUtil.notNullize((String)watcherName));
                outputStream.writeUTF(StringUtil.notNullize((String)sourceFileName));
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static DataContext getContext(final Project project, final VirtualFile file) {
        THashMap dataId2data = new THashMap();
        dataId2data.put(CommonDataKeys.PROJECT.getName(), project);
        dataId2data.put(CommonDataKeys.VIRTUAL_FILE.getName(), file);
        dataId2data.put(PlatformDataKeys.PROJECT_FILE_DIRECTORY.getName(), project.getBaseDir());
        return SimpleDataContext.getSimpleContext((Map)dataId2data, (DataContext)new DataContext(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (dataId.equals(LangDataKeys.MODULE.getName())) {
                    return ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
                }
                return null;
            }
        });
    }

    public static String getPathByRelativePath(String basePath, String relativePath, String separator) {
        LinkedList<String> path = new LinkedList<String>(Arrays.asList(basePath.split(separator)));
        for (String step : relativePath.split(separator)) {
            if ("..".equals(step)) {
                if (path.isEmpty()) {
                    return null;
                }
                path.removeLast();
                continue;
            }
            path.add(step);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < path.size(); ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(path.get(i));
        }
        return result.toString();
    }

    public static String getPresentableNames(List<TaskOptions> tasks) {
        return Arrays.toString(ContainerUtil.map(tasks, TaskOptions::getName).toArray());
    }

    @NotNull
    public static List<VirtualFile> findRoots(VirtualFile file, @NotNull Project project, TaskOptions option) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/util/TaskUtils", "findRoots"));
        }
        ArrayList result = new ArrayList();
        GlobalSearchScope scope = option.getFileScope(project);
        String extension = file.getExtension();
        boolean trackOnlyRoots = option.isTrackOnlyRoot();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/util/TaskUtils", "lambda$findRoots$0"));
            }
            for (FileDependencyFinder dependencyFinder : (FileDependencyFinder[])FileDependencyFinder.EP_NAME.getExtensions()) {
                if (!dependencyFinder.accept(extension) || !trackOnlyRoots && !dependencyFinder.trackAllDependentFiles()) continue;
                List<VirtualFile> files = TaskUtils.findDependentFiles(project, file, dependencyFinder, scope, trackOnlyRoots);
                result.addAll(files);
            }
        });
        List<Object> list = result.isEmpty() ? Collections.singletonList(file) : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/util/TaskUtils", "findRoots"));
        }
        return list;
    }

    @Nullable
    public static FileDependencyFinder findDependencyFinderForExtension(String extension) {
        for (FileDependencyFinder dependencyFinder : (FileDependencyFinder[])FileDependencyFinder.EP_NAME.getExtensions()) {
            if (!dependencyFinder.accept(extension)) continue;
            return dependencyFinder;
        }
        return null;
    }

    @NotNull
    private static List<VirtualFile> findDependentFiles(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileDependencyFinder finder, @NotNull GlobalSearchScope scope, boolean trackOnlyRoots) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/util/TaskUtils", "findDependentFiles"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/util/TaskUtils", "findDependentFiles"));
        }
        if (finder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finder", "com/intellij/plugins/watcher/util/TaskUtils", "findDependentFiles"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/plugins/watcher/util/TaskUtils", "findDependentFiles"));
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        THashSet visited = new THashSet();
        LinkedList<VirtualFile> queue = new LinkedList<VirtualFile>();
        queue.add(file);
        while (!queue.isEmpty()) {
            VirtualFile currentFile = (VirtualFile)queue.removeFirst();
            if (!visited.add(currentFile)) continue;
            Set<VirtualFile> dependentFiles = finder.findDependentFiles(project, currentFile, scope);
            if (dependentFiles.isEmpty()) {
                roots.add(currentFile);
                continue;
            }
            queue.addAll(dependentFiles);
        }
        ArrayList<VirtualFile> arrayList = trackOnlyRoots ? roots : new ArrayList<VirtualFile>((Collection<VirtualFile>)visited);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/util/TaskUtils", "findDependentFiles"));
        }
        return arrayList;
    }
}

