/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AsyncUpdateAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.merge.PerforceMergeProvider;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

public class ResolveAction
extends AsyncUpdateAction<VcsContext>
implements DumbAware {
    protected VcsContext prepareDataFromContext(AnActionEvent e) {
        return VcsContextFactory.SERVICE.getInstance().createCachedContextOn(e);
    }

    protected void performUpdate(Presentation presentation, VcsContext context) {
        Project project = context.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        List<VirtualFile> selectedFiles = ResolveAction.getSelectedPerforceFiles(context, project);
        PerforceSettings perforceSettings = PerforceSettings.getSettings(project);
        if (selectedFiles.isEmpty() || !perforceSettings.ENABLED) {
            presentation.setEnabled(false);
            return;
        }
        for (VirtualFile selectedFile : selectedFiles) {
            long serverVersion;
            try {
                serverVersion = perforceSettings.getServerVersionCached(perforceSettings.getConnectionForFile(selectedFile));
            }
            catch (VcsException e) {
                presentation.setEnabled(false);
                return;
            }
            if (serverVersion < 2004L) {
                presentation.setEnabled(false);
                return;
            }
            if (!selectedFile.isDirectory()) continue;
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(!ResolveAction.getMergedFiles(project, selectedFiles).isEmpty());
    }

    private static List<VirtualFile> getSelectedPerforceFiles(VcsContext context, Project project) {
        return ContainerUtil.filter((Object[])context.getSelectedFiles(), file -> VcsUtil.getVcsFor((Project)project, (VirtualFile)file) instanceof PerforceVcs);
    }

    private static List<VirtualFile> getMergedFiles(Project project, List<VirtualFile> selectedFiles) {
        ArrayList merged = ContainerUtil.newArrayList();
        for (VirtualFile file : selectedFiles) {
            FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(file);
            if (status != FileStatus.MERGE && status != FileStatus.MERGED_WITH_CONFLICTS) continue;
            merged.add(file);
        }
        return merged;
    }

    public void actionPerformed(AnActionEvent e) {
        VcsContext context = VcsContextFactory.SERVICE.getInstance().createCachedContextOn(e);
        Project project = context.getProject();
        new PerforceMergeProvider(project).showMergeDialog(ResolveAction.getMergedFiles(project, ResolveAction.getSelectedPerforceFiles(context, project)));
    }
}

