/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.connections.AbstractP4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigFields;

public class P4ConfigHelper {
    @NonNls
    public static final String P4_CONFIG = "P4CONFIG";
    private final Map<File, File> myAlreadyFoundConfigs = ContainerUtil.newHashMap();

    public static boolean hasP4ConfigSettingInEnvironment() {
        return EnvironmentUtil.getValue((String)P4_CONFIG) != null;
    }

    @Nullable
    public static String getP4ConfigFileName() {
        return EnvironmentUtil.getValue((String)P4_CONFIG);
    }

    @Nullable
    public static String getP4IgnoreFileName() {
        String testValue = AbstractP4Connection.getTestEnvironment().get(P4ConfigFields.P4IGNORE.getName());
        if (testValue != null) {
            return testValue;
        }
        return EnvironmentUtil.getValue((String)P4ConfigFields.P4IGNORE.getName());
    }

    @Nullable
    public File findDirWithP4ConfigFile(@NotNull VirtualFile parent, @NotNull String p4ConfigFileName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/idea/perforce/perforce/connections/P4ConfigHelper", "findDirWithP4ConfigFile"));
        }
        if (p4ConfigFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p4ConfigFileName", "org/jetbrains/idea/perforce/perforce/connections/P4ConfigHelper", "findDirWithP4ConfigFile"));
        }
        ArrayList paths = ContainerUtil.newArrayList();
        for (File current = VfsUtilCore.virtualToIoFile((VirtualFile)parent); current != null; current = current.getParentFile()) {
            File calculated = this.myAlreadyFoundConfigs.get(current);
            if (calculated != null) {
                return this.cacheForAllChildren(paths, calculated);
            }
            File candidate = new File(current, p4ConfigFileName);
            if (candidate.exists() && !candidate.isDirectory()) {
                this.myAlreadyFoundConfigs.put(current, current);
                return this.cacheForAllChildren(paths, current);
            }
            paths.add(current);
        }
        return null;
    }

    private File cacheForAllChildren(List<File> paths, File calculated) {
        for (File path : paths) {
            this.myAlreadyFoundConfigs.put(path, calculated);
        }
        return calculated;
    }
}

