/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.perforce.perforce.jobs.JobsSearchSpecificator;

public class ByNamesConstraint
implements JobsSearchSpecificator {
    private final List<String> myNames;

    public ByNamesConstraint(List<String> names) {
        this.myNames = names;
    }

    @Override
    public String[] addParams(String[] s) {
        if (this.myNames.isEmpty()) {
            return s;
        }
        ArrayList<String> list = new ArrayList<String>(s.length + 2);
        ContainerUtil.addAll(list, (Object[])s);
        list.add("-e");
        list.add(this.getNamesConstraint());
        return ArrayUtil.toStringArray(list);
    }

    @Override
    public int getMaxCount() {
        return -1;
    }

    private String getNamesConstraint() {
        return "Job=" + StringUtil.join(this.myNames, s -> StringUtil.replace((String)s, (String[])new String[]{"\\", "&", "|", "=", ">", "<", "^"}, (String[])new String[]{"\\\\", "\\&", "\\|", "\\=", "\\>", "\\<", "\\^"}), (String)"|");
    }
}

