/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class Notifier {
    public static final String INSPECT = "inspect";
    public static final String FIX = "fix";
    private final Project myProject;
    private final PerforceSettings mySettings;
    private final MyInnerNotifier myInnerNotifier;

    public Notifier(Project project, PerforceLoginManager loginManager, PerforceSettings perforceSettings) {
        this.myProject = project;
        this.mySettings = perforceSettings;
        this.myInnerNotifier = new MyInnerNotifier(this.myProject, loginManager);
    }

    public void ensureNotify(P4Connection connection) {
        if (!this.mySettings.ENABLED || !this.mySettings.USE_LOGIN) {
            return;
        }
        this.myInnerNotifier.ensureNotify(connection);
    }

    public void removeLazyNotification(P4Connection connection) {
        this.myInnerNotifier.removeLazyNotification(connection);
    }

    public void showPasswordWasOk(boolean value) {
        if (value) {
            new VcsBalloonProblemNotifier(this.myProject, "Successfully logged into Perforce", MessageType.INFO).run();
        } else {
            new VcsBalloonProblemNotifier(this.myProject, "Not logged into Perforce", MessageType.ERROR).run();
        }
    }

    public boolean isEmpty() {
        return this.myInnerNotifier.isEmpty();
    }

    public void clear() {
        this.myInnerNotifier.clear();
    }

    private static class MyInnerNotifier
    extends GenericNotifierImpl<P4Connection, ConnectionId> {
        private final PerforceLoginManager myLoginManager;

        private MyInnerNotifier(Project project, PerforceLoginManager loginManager) {
            super(project, "Perforce", "Not Logged To Perforce", NotificationType.ERROR);
            this.myLoginManager = loginManager;
        }

        @NotNull
        protected String getNotificationContent(P4Connection connection) {
            String workingDir = connection.getWorkingDir();
            String string = (workingDir == null ? "" : "Cannot login to Perforce at " + workingDir + "<br>") + "<a href=\"" + Notifier.FIX + "\">Click to fix</a><br><a href=\"" + Notifier.INSPECT + "\">Inspect</a> connection state";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/login/Notifier$MyInnerNotifier", "getNotificationContent"));
            }
            return string;
        }

        protected boolean ask(P4Connection obj, String description) {
            if (Notifier.FIX.equals(description)) {
                return this.myLoginManager.checkAndRepair(obj);
            }
            if (Notifier.INSPECT.equals(description)) {
                PerforceConnectionProblemsNotifier.showConnectionState(this.myProject, true);
                return false;
            }
            return false;
        }

        @NotNull
        protected ConnectionId getKey(P4Connection obj) {
            ConnectionId connectionId = obj.getId();
            if (connectionId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/login/Notifier$MyInnerNotifier", "getKey"));
            }
            return connectionId;
        }
    }
}

