/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.util.tracer;

import com.intellij.util.Consumer;
import java.math.BigDecimal;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.util.tracer.IntervalStatistics;
import org.jetbrains.idea.perforce.util.tracer.Tracer;

class ConcurrentThreadsStatistics<Kind extends Enum>
extends IntervalStatistics<Boolean, MaxCurrentPair, MaxAveragePairAverage>
implements Tracer<Kind, Object> {
    public ConcurrentThreadsStatistics(long intervalInMillis, int historyQueueSize, @Nullable Runnable switchListener) {
        super(intervalInMillis, historyQueueSize, () -> new MaxCurrentPair(), () -> new MaxAveragePairAverage(), switchListener);
    }

    @Override
    public Object start(Kind kind, String presentation) {
        this.step(true);
        return this;
    }

    @Override
    public void stop(Object o, Kind kind, String presentation) {
        this.step(false);
    }

    public static class MaxAveragePairAverage
    implements Consumer<MaxCurrentPair> {
        private int myMax = 0;
        private BigDecimal myTotal = new BigDecimal(0);
        private int myCnt = 0;

        public void consume(MaxCurrentPair pair) {
            int max = pair.getMax();
            if (max > this.myMax) {
                this.myMax = max;
            }
            ++this.myCnt;
            this.myTotal = this.myTotal.add(new BigDecimal(max));
        }

        public int getMax() {
            return this.myMax;
        }

        public BigDecimal getTotal() {
            return this.myTotal;
        }

        public int getCnt() {
            return this.myCnt;
        }
    }

    public static class MaxCurrentPair
    implements Consumer<Boolean> {
        private int myCurrent = 0;
        private int myMax = 0;

        public void consume(Boolean entered) {
            if (entered.booleanValue()) {
                this.enter();
            } else {
                this.exit();
            }
        }

        public void enter() {
            ++this.myCurrent;
            if (this.myCurrent > this.myMax) {
                this.myMax = this.myCurrent;
            }
        }

        public void exit() {
            --this.myCurrent;
        }

        public int getMax() {
            return this.myMax;
        }
    }
}

