/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.workitemtracking.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.AlmHttpClientBase;
import com.microsoft.alm.client.model.ApiResourceVersion;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.workitemtracking.webapi.models.AttachmentReference;
import com.microsoft.alm.workitemtracking.webapi.models.FieldDependentRule;
import com.microsoft.alm.workitemtracking.webapi.models.FieldsToEvaluate;
import com.microsoft.alm.workitemtracking.webapi.models.ProvisioningResult;
import com.microsoft.alm.workitemtracking.webapi.models.QueryExpand;
import com.microsoft.alm.workitemtracking.webapi.models.QueryHierarchyItem;
import com.microsoft.alm.workitemtracking.webapi.models.ReportingWorkItemLinksBatch;
import com.microsoft.alm.workitemtracking.webapi.models.ReportingWorkItemRevisionsBatch;
import com.microsoft.alm.workitemtracking.webapi.models.ReportingWorkItemRevisionsFilter;
import com.microsoft.alm.workitemtracking.webapi.models.TreeStructureGroup;
import com.microsoft.alm.workitemtracking.webapi.models.Wiql;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItem;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemClassificationNode;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemExpand;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemField;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemHistory;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemQueryResult;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemRelationType;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemType;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemTypeCategory;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemTypeTemplate;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemTypeTemplateUpdateModel;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemUpdate;
import com.microsoft.visualstudio.services.webapi.patch.json.JsonPatchDocument;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Invocation;

public abstract class WorkItemTrackingHttpClientBase
extends AlmHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected WorkItemTrackingHttpClientBase(Object jaxrsClient, URI baseUrl) {
        super(jaxrsClient, baseUrl);
    }

    protected WorkItemTrackingHttpClientBase(Object tfsConnection) {
        super(tfsConnection);
    }

    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public AttachmentReference createAttachment(InputStream uploadStream, String fileName, String uploadType) {
        UUID locationId = UUID.fromString("e07b5fa4-1499-494d-a496-64b860fd64ff");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotEmpty("uploadType", uploadType);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)uploadStream, APPLICATION_OCTET_STREAM_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (AttachmentReference)super.sendRequest((Object)httpRequest, AttachmentReference.class);
    }

    public InputStream getAttachmentContent(UUID id, String fileName) {
        UUID locationId = UUID.fromString("e07b5fa4-1499-494d-a496-64b860fd64ff");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getAttachmentZip(UUID id, String fileName) {
        UUID locationId = UUID.fromString("e07b5fa4-1499-494d-a496-64b860fd64ff");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public List<WorkItemClassificationNode> getRootNodes(String project, Integer depth) {
        UUID locationId = UUID.fromString("a70579d1-f53a-48ee-a5be-7be8659023b9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$depth", (Object)depth);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItemClassificationNode>>(){});
    }

    public List<WorkItemClassificationNode> getRootNodes(UUID project, Integer depth) {
        UUID locationId = UUID.fromString("a70579d1-f53a-48ee-a5be-7be8659023b9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$depth", (Object)depth);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItemClassificationNode>>(){});
    }

    public WorkItemClassificationNode createOrUpdateClassificationNode(WorkItemClassificationNode postedNode, String project, TreeStructureGroup structureGroup, String path) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)postedNode, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (WorkItemClassificationNode)super.sendRequest((Object)httpRequest, WorkItemClassificationNode.class);
    }

    public WorkItemClassificationNode createOrUpdateClassificationNode(WorkItemClassificationNode postedNode, UUID project, TreeStructureGroup structureGroup, String path) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)postedNode, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (WorkItemClassificationNode)super.sendRequest((Object)httpRequest, WorkItemClassificationNode.class);
    }

    public void deleteClassificationNode(String project, TreeStructureGroup structureGroup, String path, Integer reclassifyId) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$reclassifyId", (Object)reclassifyId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deleteClassificationNode(UUID project, TreeStructureGroup structureGroup, String path, Integer reclassifyId) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$reclassifyId", (Object)reclassifyId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public WorkItemClassificationNode getClassificationNode(String project, TreeStructureGroup structureGroup, String path, Integer depth) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$depth", (Object)depth);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItemClassificationNode)super.sendRequest((Object)httpRequest, WorkItemClassificationNode.class);
    }

    public WorkItemClassificationNode getClassificationNode(UUID project, TreeStructureGroup structureGroup, String path, Integer depth) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$depth", (Object)depth);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItemClassificationNode)super.sendRequest((Object)httpRequest, WorkItemClassificationNode.class);
    }

    public WorkItemClassificationNode updateClassificationNode(WorkItemClassificationNode postedNode, String project, TreeStructureGroup structureGroup, String path) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)postedNode, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (WorkItemClassificationNode)super.sendRequest((Object)httpRequest, WorkItemClassificationNode.class);
    }

    public WorkItemClassificationNode updateClassificationNode(WorkItemClassificationNode postedNode, UUID project, TreeStructureGroup structureGroup, String path) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)postedNode, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (WorkItemClassificationNode)super.sendRequest((Object)httpRequest, WorkItemClassificationNode.class);
    }

    public WorkItemField getField(String field) {
        UUID locationId = UUID.fromString("b51fd764-e5c2-4b9b-aaf7-3395cf4bdd94");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("field", field);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemField)super.sendRequest((Object)httpRequest, WorkItemField.class);
    }

    public List<WorkItemField> getFields() {
        UUID locationId = UUID.fromString("b51fd764-e5c2-4b9b-aaf7-3395cf4bdd94");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItemField>>(){});
    }

    public List<WorkItemHistory> getHistory(int id, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("f74eba29-47a1-4152-9381-84040aced527");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItemHistory>>(){});
    }

    public WorkItemHistory getHistoryById(int id, int revisionNumber) {
        UUID locationId = UUID.fromString("f74eba29-47a1-4152-9381-84040aced527");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("id", id);
        routeValues.put("revisionNumber", revisionNumber);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemHistory)super.sendRequest((Object)httpRequest, WorkItemHistory.class);
    }

    public QueryHierarchyItem createQuery(QueryHierarchyItem postedQuery, String project, String query) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)postedQuery, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (QueryHierarchyItem)super.sendRequest((Object)httpRequest, QueryHierarchyItem.class);
    }

    public QueryHierarchyItem createQuery(QueryHierarchyItem postedQuery, UUID project, String query) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)postedQuery, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (QueryHierarchyItem)super.sendRequest((Object)httpRequest, QueryHierarchyItem.class);
    }

    public void deleteQuery(String project, String query) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deleteQuery(UUID project, String query) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public List<QueryHierarchyItem> getQueries(String project, QueryExpand expand, Integer depth, Boolean includeDeleted) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$expand", (Object)expand);
        queryParameters.addIfNotNull("$depth", (Object)depth);
        queryParameters.addIfNotNull("$includeDeleted", (Object)includeDeleted);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<QueryHierarchyItem>>(){});
    }

    public List<QueryHierarchyItem> getQueries(UUID project, QueryExpand expand, Integer depth, Boolean includeDeleted) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$expand", (Object)expand);
        queryParameters.addIfNotNull("$depth", (Object)depth);
        queryParameters.addIfNotNull("$includeDeleted", (Object)includeDeleted);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<QueryHierarchyItem>>(){});
    }

    public QueryHierarchyItem getQuery(String project, String query, QueryExpand expand, Integer depth, Boolean includeDeleted) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$expand", (Object)expand);
        queryParameters.addIfNotNull("$depth", (Object)depth);
        queryParameters.addIfNotNull("$includeDeleted", (Object)includeDeleted);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (QueryHierarchyItem)super.sendRequest((Object)httpRequest, QueryHierarchyItem.class);
    }

    public QueryHierarchyItem getQuery(UUID project, String query, QueryExpand expand, Integer depth, Boolean includeDeleted) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$expand", (Object)expand);
        queryParameters.addIfNotNull("$depth", (Object)depth);
        queryParameters.addIfNotNull("$includeDeleted", (Object)includeDeleted);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (QueryHierarchyItem)super.sendRequest((Object)httpRequest, QueryHierarchyItem.class);
    }

    public QueryHierarchyItem updateQuery(QueryHierarchyItem queryUpdate, String project, String query, Boolean undeleteDescendants) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$undeleteDescendants", (Object)undeleteDescendants);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)queryUpdate, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (QueryHierarchyItem)super.sendRequest((Object)httpRequest, QueryHierarchyItem.class);
    }

    public QueryHierarchyItem updateQuery(QueryHierarchyItem queryUpdate, UUID project, String query, Boolean undeleteDescendants) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$undeleteDescendants", (Object)undeleteDescendants);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)queryUpdate, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (QueryHierarchyItem)super.sendRequest((Object)httpRequest, QueryHierarchyItem.class);
    }

    public WorkItem getRevision(int id, int revisionNumber, WorkItemExpand expand) {
        UUID locationId = UUID.fromString("a00c85a5-80fa-4565-99c3-bcd2181434bb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("id", id);
        routeValues.put("revisionNumber", revisionNumber);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$expand", (Object)expand);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItem)super.sendRequest((Object)httpRequest, WorkItem.class);
    }

    public List<WorkItem> getRevisions(int id, Integer top, Integer skip, WorkItemExpand expand) {
        UUID locationId = UUID.fromString("a00c85a5-80fa-4565-99c3-bcd2181434bb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$expand", (Object)expand);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItem>>(){});
    }

    public void evaluateRulesOnField(FieldsToEvaluate ruleEngineInput) {
        UUID locationId = UUID.fromString("1a3a1536-dca6-4509-b9c3-dd9bb2981506");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)ruleEngineInput, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public WorkItemUpdate getUpdate(int id, int updateNumber) {
        UUID locationId = UUID.fromString("6570bf97-d02c-4a91-8d93-3abe9895b1a9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("id", id);
        routeValues.put("updateNumber", updateNumber);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemUpdate)super.sendRequest((Object)httpRequest, WorkItemUpdate.class);
    }

    public List<WorkItemUpdate> getUpdates(int id, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("6570bf97-d02c-4a91-8d93-3abe9895b1a9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItemUpdate>>(){});
    }

    public WorkItemQueryResult queryByWiql(Wiql wiql) {
        UUID locationId = UUID.fromString("1a9c53f7-f243-4447-b110-35ef023636e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)wiql, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (WorkItemQueryResult)super.sendRequest((Object)httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryByWiql(Wiql wiql, String project) {
        UUID locationId = UUID.fromString("1a9c53f7-f243-4447-b110-35ef023636e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)wiql, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (WorkItemQueryResult)super.sendRequest((Object)httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryByWiql(Wiql wiql, UUID project) {
        UUID locationId = UUID.fromString("1a9c53f7-f243-4447-b110-35ef023636e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)wiql, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (WorkItemQueryResult)super.sendRequest((Object)httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryByWiql(Wiql wiql, String project, String team) {
        UUID locationId = UUID.fromString("1a9c53f7-f243-4447-b110-35ef023636e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)wiql, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (WorkItemQueryResult)super.sendRequest((Object)httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryByWiql(Wiql wiql, UUID project, UUID team) {
        UUID locationId = UUID.fromString("1a9c53f7-f243-4447-b110-35ef023636e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)wiql, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (WorkItemQueryResult)super.sendRequest((Object)httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryById(UUID id) {
        UUID locationId = UUID.fromString("a02355f5-5f8a-4671-8e32-369d23aac83d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("id", id);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemQueryResult)super.sendRequest((Object)httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryById(String project, UUID id) {
        UUID locationId = UUID.fromString("a02355f5-5f8a-4671-8e32-369d23aac83d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemQueryResult)super.sendRequest((Object)httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryById(UUID project, UUID id) {
        UUID locationId = UUID.fromString("a02355f5-5f8a-4671-8e32-369d23aac83d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemQueryResult)super.sendRequest((Object)httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryById(String project, String team, UUID id) {
        UUID locationId = UUID.fromString("a02355f5-5f8a-4671-8e32-369d23aac83d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemQueryResult)super.sendRequest((Object)httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryById(UUID project, UUID team, UUID id) {
        UUID locationId = UUID.fromString("a02355f5-5f8a-4671-8e32-369d23aac83d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemQueryResult)super.sendRequest((Object)httpRequest, WorkItemQueryResult.class);
    }

    public ReportingWorkItemLinksBatch getReportingLinks(String project, List<String> types, Integer watermark, Date startDateTime) {
        UUID locationId = UUID.fromString("b5b5b6d0-0308-40a1-b3f4-b9bb3c66878f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotNull("watermark", (Object)watermark);
        queryParameters.addIfNotNull("startDateTime", (Object)startDateTime);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (ReportingWorkItemLinksBatch)super.sendRequest((Object)httpRequest, ReportingWorkItemLinksBatch.class);
    }

    public ReportingWorkItemLinksBatch getReportingLinks(UUID project, List<String> types, Integer watermark, Date startDateTime) {
        UUID locationId = UUID.fromString("b5b5b6d0-0308-40a1-b3f4-b9bb3c66878f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotNull("watermark", (Object)watermark);
        queryParameters.addIfNotNull("startDateTime", (Object)startDateTime);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (ReportingWorkItemLinksBatch)super.sendRequest((Object)httpRequest, ReportingWorkItemLinksBatch.class);
    }

    public ReportingWorkItemLinksBatch getReportingLinks(List<String> types, Integer watermark, Date startDateTime) {
        UUID locationId = UUID.fromString("b5b5b6d0-0308-40a1-b3f4-b9bb3c66878f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotNull("watermark", (Object)watermark);
        queryParameters.addIfNotNull("startDateTime", (Object)startDateTime);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (ReportingWorkItemLinksBatch)super.sendRequest((Object)httpRequest, ReportingWorkItemLinksBatch.class);
    }

    public WorkItemRelationType getRelationType(String relation) {
        UUID locationId = UUID.fromString("f5d33bc9-5b49-4a3c-a9bd-f3cd46dd2165");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("relation", relation);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemRelationType)super.sendRequest((Object)httpRequest, WorkItemRelationType.class);
    }

    public List<WorkItemRelationType> getRelationTypes() {
        UUID locationId = UUID.fromString("f5d33bc9-5b49-4a3c-a9bd-f3cd46dd2165");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItemRelationType>>(){});
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsGet(String project, List<String> fields, List<String> types, Integer watermark, Date startDateTime, Boolean includeIdentityRef) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fields", fields);
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotNull("watermark", (Object)watermark);
        queryParameters.addIfNotNull("startDateTime", (Object)startDateTime);
        queryParameters.addIfNotNull("includeIdentityRef", (Object)includeIdentityRef);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (ReportingWorkItemRevisionsBatch)super.sendRequest((Object)httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsGet(UUID project, List<String> fields, List<String> types, Integer watermark, Date startDateTime, Boolean includeIdentityRef) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fields", fields);
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotNull("watermark", (Object)watermark);
        queryParameters.addIfNotNull("startDateTime", (Object)startDateTime);
        queryParameters.addIfNotNull("includeIdentityRef", (Object)includeIdentityRef);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (ReportingWorkItemRevisionsBatch)super.sendRequest((Object)httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsGet(List<String> fields, List<String> types, Integer watermark, Date startDateTime, Boolean includeIdentityRef) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fields", fields);
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotNull("watermark", (Object)watermark);
        queryParameters.addIfNotNull("startDateTime", (Object)startDateTime);
        queryParameters.addIfNotNull("includeIdentityRef", (Object)includeIdentityRef);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (ReportingWorkItemRevisionsBatch)super.sendRequest((Object)httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsPost(ReportingWorkItemRevisionsFilter filter, Integer watermark, Date startDateTime) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("watermark", (Object)watermark);
        queryParameters.addIfNotNull("startDateTime", (Object)startDateTime);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)filter, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (ReportingWorkItemRevisionsBatch)super.sendRequest((Object)httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsPost(ReportingWorkItemRevisionsFilter filter, String project, Integer watermark, Date startDateTime) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("watermark", (Object)watermark);
        queryParameters.addIfNotNull("startDateTime", (Object)startDateTime);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)filter, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (ReportingWorkItemRevisionsBatch)super.sendRequest((Object)httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsPost(ReportingWorkItemRevisionsFilter filter, UUID project, Integer watermark, Date startDateTime) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("watermark", (Object)watermark);
        queryParameters.addIfNotNull("startDateTime", (Object)startDateTime);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)filter, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (ReportingWorkItemRevisionsBatch)super.sendRequest((Object)httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public WorkItem getWorkItem(int id, List<String> fields, Date asOf, WorkItemExpand expand) {
        UUID locationId = UUID.fromString("72c7ddf8-2cdc-4f60-90cd-ab71c14a399b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fields", fields);
        queryParameters.addIfNotNull("asOf", (Object)asOf);
        queryParameters.addIfNotNull("$expand", (Object)expand);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItem)super.sendRequest((Object)httpRequest, WorkItem.class);
    }

    public List<WorkItem> getWorkItems(List<Integer> ids, List<String> fields, Date asOf, WorkItemExpand expand) {
        UUID locationId = UUID.fromString("72c7ddf8-2cdc-4f60-90cd-ab71c14a399b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("ids", ids);
        queryParameters.addIfNotNull("fields", fields);
        queryParameters.addIfNotNull("asOf", (Object)asOf);
        queryParameters.addIfNotNull("$expand", (Object)expand);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItem>>(){});
    }

    public WorkItem updateWorkItem(JsonPatchDocument document, int id, Boolean validateOnly, Boolean bypassRules) {
        UUID locationId = UUID.fromString("72c7ddf8-2cdc-4f60-90cd-ab71c14a399b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("validateOnly", (Object)validateOnly);
        queryParameters.addIfNotNull("bypassRules", (Object)bypassRules);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)document, APPLICATION_JSON_PATCH_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItem)super.sendRequest((Object)httpRequest, WorkItem.class);
    }

    public WorkItem getWorkItemTemplate(String project, String type, String fields, Date asOf, WorkItemExpand expand) {
        UUID locationId = UUID.fromString("62d3d110-0047-428c-ad3c-4fe872c91c74");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("fields", fields);
        queryParameters.addIfNotNull("asOf", (Object)asOf);
        queryParameters.addIfNotNull("$expand", (Object)expand);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItem)super.sendRequest((Object)httpRequest, WorkItem.class);
    }

    public WorkItem getWorkItemTemplate(UUID project, String type, String fields, Date asOf, WorkItemExpand expand) {
        UUID locationId = UUID.fromString("62d3d110-0047-428c-ad3c-4fe872c91c74");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("fields", fields);
        queryParameters.addIfNotNull("asOf", (Object)asOf);
        queryParameters.addIfNotNull("$expand", (Object)expand);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItem)super.sendRequest((Object)httpRequest, WorkItem.class);
    }

    public WorkItem updateWorkItemTemplate(JsonPatchDocument document, String project, String type, Boolean validateOnly, Boolean bypassRules) {
        UUID locationId = UUID.fromString("62d3d110-0047-428c-ad3c-4fe872c91c74");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("validateOnly", (Object)validateOnly);
        queryParameters.addIfNotNull("bypassRules", (Object)bypassRules);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)document, APPLICATION_JSON_PATCH_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItem)super.sendRequest((Object)httpRequest, WorkItem.class);
    }

    public WorkItem updateWorkItemTemplate(JsonPatchDocument document, UUID project, String type, Boolean validateOnly, Boolean bypassRules) {
        UUID locationId = UUID.fromString("62d3d110-0047-428c-ad3c-4fe872c91c74");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("validateOnly", (Object)validateOnly);
        queryParameters.addIfNotNull("bypassRules", (Object)bypassRules);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)document, APPLICATION_JSON_PATCH_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItem)super.sendRequest((Object)httpRequest, WorkItem.class);
    }

    public List<WorkItemTypeCategory> getWorkItemTypeCategories(String project) {
        UUID locationId = UUID.fromString("9b9f5734-36c8-415e-ba67-f83b45c31408");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItemTypeCategory>>(){});
    }

    public List<WorkItemTypeCategory> getWorkItemTypeCategories(UUID project) {
        UUID locationId = UUID.fromString("9b9f5734-36c8-415e-ba67-f83b45c31408");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItemTypeCategory>>(){});
    }

    public WorkItemTypeCategory getWorkItemTypeCategory(String project, String category) {
        UUID locationId = UUID.fromString("9b9f5734-36c8-415e-ba67-f83b45c31408");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("category", category);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemTypeCategory)super.sendRequest((Object)httpRequest, WorkItemTypeCategory.class);
    }

    public WorkItemTypeCategory getWorkItemTypeCategory(UUID project, String category) {
        UUID locationId = UUID.fromString("9b9f5734-36c8-415e-ba67-f83b45c31408");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("category", category);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemTypeCategory)super.sendRequest((Object)httpRequest, WorkItemTypeCategory.class);
    }

    public WorkItemType getWorkItemType(String project, String type) {
        UUID locationId = UUID.fromString("7c8d7a76-4a09-43e8-b5df-bd792f4ac6aa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemType)super.sendRequest((Object)httpRequest, WorkItemType.class);
    }

    public WorkItemType getWorkItemType(UUID project, String type) {
        UUID locationId = UUID.fromString("7c8d7a76-4a09-43e8-b5df-bd792f4ac6aa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WorkItemType)super.sendRequest((Object)httpRequest, WorkItemType.class);
    }

    public List<WorkItemType> getWorkItemTypes(String project) {
        UUID locationId = UUID.fromString("7c8d7a76-4a09-43e8-b5df-bd792f4ac6aa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItemType>>(){});
    }

    public List<WorkItemType> getWorkItemTypes(UUID project) {
        UUID locationId = UUID.fromString("7c8d7a76-4a09-43e8-b5df-bd792f4ac6aa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WorkItemType>>(){});
    }

    public FieldDependentRule getDependentFields(String project, String type, String field) {
        UUID locationId = UUID.fromString("bd293ce5-3d25-4192-8e67-e8092e879efb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        routeValues.put("field", field);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (FieldDependentRule)super.sendRequest((Object)httpRequest, FieldDependentRule.class);
    }

    public FieldDependentRule getDependentFields(UUID project, String type, String field) {
        UUID locationId = UUID.fromString("bd293ce5-3d25-4192-8e67-e8092e879efb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        routeValues.put("field", field);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (FieldDependentRule)super.sendRequest((Object)httpRequest, FieldDependentRule.class);
    }

    public WorkItemTypeTemplate exportWorkItemTypeDefinition(String project, String type, Boolean exportGlobalLists) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("exportGlobalLists", (Object)exportGlobalLists);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItemTypeTemplate)super.sendRequest((Object)httpRequest, WorkItemTypeTemplate.class);
    }

    public WorkItemTypeTemplate exportWorkItemTypeDefinition(UUID project, String type, Boolean exportGlobalLists) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("exportGlobalLists", (Object)exportGlobalLists);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItemTypeTemplate)super.sendRequest((Object)httpRequest, WorkItemTypeTemplate.class);
    }

    public WorkItemTypeTemplate exportWorkItemTypeDefinition(String type, Boolean exportGlobalLists) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("exportGlobalLists", (Object)exportGlobalLists);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WorkItemTypeTemplate)super.sendRequest((Object)httpRequest, WorkItemTypeTemplate.class);
    }

    public ProvisioningResult updateWorkItemTypeDefinition(WorkItemTypeTemplateUpdateModel updateModel) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)updateModel, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (ProvisioningResult)super.sendRequest((Object)httpRequest, ProvisioningResult.class);
    }

    public ProvisioningResult updateWorkItemTypeDefinition(WorkItemTypeTemplateUpdateModel updateModel, String project) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)updateModel, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (ProvisioningResult)super.sendRequest((Object)httpRequest, ProvisioningResult.class);
    }

    public ProvisioningResult updateWorkItemTypeDefinition(WorkItemTypeTemplateUpdateModel updateModel, UUID project) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)updateModel, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (ProvisioningResult)super.sendRequest((Object)httpRequest, ProvisioningResult.class);
    }
}

