/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.dockerjava.api.model.Volume;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Volumes {
    private Volume[] volumes;

    public Volumes(Volume ... volumes) {
        this.volumes = volumes;
    }

    public Volumes(List<Volume> volumes) {
        this.volumes = volumes.toArray(new Volume[volumes.size()]);
    }

    public Volume[] getVolumes() {
        return this.volumes;
    }

    public static class Deserializer
    extends JsonDeserializer<Volumes> {
        public Volumes deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ArrayList<Volume> volumes = new ArrayList<Volume>();
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry field = (Map.Entry)it.next();
                if (((JsonNode)field.getValue()).equals((Object)NullNode.getInstance())) continue;
                String path = (String)field.getKey();
                Volume volume = new Volume(path);
                volumes.add(volume);
            }
            return new Volumes(volumes.toArray(new Volume[0]));
        }
    }

    public static class Serializer
    extends JsonSerializer<Volumes> {
        public void serialize(Volumes volumes, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartObject();
            for (Volume volume : volumes.getVolumes()) {
                jsonGen.writeFieldName(volume.getPath());
                jsonGen.writeStartObject();
                jsonGen.writeEndObject();
            }
            jsonGen.writeEndObject();
        }
    }
}

