/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty;

import com.github.dockerjava.netty.ChannelProvider;
import com.github.dockerjava.netty.InvocationBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WebTarget {
    private ChannelProvider channelProvider;
    private List<String> path = new ArrayList<String>();
    private Map<String, String> queryParams = new HashMap<String, String>();
    private static final String PATH_SEPARATOR = "/";

    public WebTarget(ChannelProvider channelProvider) {
        this.channelProvider = channelProvider;
    }

    public WebTarget path(String ... components) {
        for (String component : components) {
            this.path.addAll(Arrays.asList(StringUtils.split((String)component, (String)PATH_SEPARATOR)));
        }
        return this;
    }

    public InvocationBuilder request() {
        String resource = PATH_SEPARATOR + StringUtils.join(this.path, (String)PATH_SEPARATOR);
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
            params.add(entry.getKey() + "=" + entry.getValue());
        }
        if (!params.isEmpty()) {
            resource = resource + "?" + StringUtils.join(params, (String)"&");
        }
        return new InvocationBuilder(this.channelProvider, resource);
    }

    public WebTarget resolveTemplate(String name, Object value) {
        ArrayList<String> newPath = new ArrayList<String>();
        for (String component : this.path) {
            component = component.replaceAll("\\{" + name + "\\}", value.toString());
            newPath.add(component);
        }
        this.path = newPath;
        return this;
    }

    public WebTarget queryParam(String name, Object value) {
        if (value != null) {
            this.queryParams.put(name, value.toString());
        }
        return this;
    }
}

