/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.plugins.unity.run.configurations;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.plugins.unity.run.configurations.UnityAttachToEditorFactory;
import com.jetbrains.resharper.plugins.unity.run.configurations.UnityAttachToEditorProfileState;
import com.jetbrains.resharper.plugins.unity.run.configurations.UnityAttachToEditorSettingsEditor;
import com.jetbrains.resharper.run.configurations.remote.RemoteConfiguration;
import com.jetbrains.resharper.run.configurations.remote.Unity.UnityProcessUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J'\u0010%\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020+H\u0016J\u001d\u0010,\u001a\u0004\u0018\u00010\u00112\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002\u00a2\u0006\u0002\u0010-J\u001d\u0010.\u001a\u0004\u0018\u00010\u00112\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002\u00a2\u0006\u0002\u0010-J\u001b\u0010/\u001a\u00020\u00112\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020+02H\u0016J\u001a\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020#2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020#2\u0006\u0010:\u001a\u00020;H\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006="}, d2={"Lcom/jetbrains/resharper/plugins/unity/run/configurations/UnityAttachToEditorConfiguration;", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "Lcom/jetbrains/resharper/run/configurations/remote/RemoteConfiguration;", "Lcom/intellij/execution/configurations/WithoutOwnBeforeRunSteps;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/jetbrains/resharper/plugins/unity/run/configurations/UnityAttachToEditorFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/plugins/unity/run/configurations/UnityAttachToEditorFactory;)V", "address", "", "getAddress", "()Ljava/lang/String;", "setAddress", "(Ljava/lang/String;)V", "pid", "", "getPid", "()Ljava/lang/Integer;", "setPid", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "play", "", "getPlay", "()Z", "setPlay", "(Z)V", "port", "getPort", "()I", "setPort", "(I)V", "checkConfiguration", "", "checkSettingsBeforeRun", "checkValidEditorInstance", "processList", "", "Lcom/intellij/execution/process/ProcessInfo;", "(Ljava/lang/Integer;[Lcom/intellij/execution/process/ProcessInfo;)Ljava/lang/Integer;", "clone", "Lcom/intellij/execution/configurations/RunConfiguration;", "findUnityEditorInstance", "([Lcom/intellij/execution/process/ProcessInfo;)Ljava/lang/Integer;", "findUnityEditorInstanceFromEditorInstanceJson", "findUnityEditorInstanceFromProcesses", "([Lcom/intellij/execution/process/ProcessInfo;)I", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "rider-unity_main"})
public final class UnityAttachToEditorConfiguration
extends RunConfigurationBase
implements RunConfigurationWithSuppressedDefaultRunAction,
RemoteConfiguration,
WithoutOwnBeforeRunSteps {
    private boolean play;
    private int port;
    @NotNull
    private String address;
    @Nullable
    private Integer pid;

    public final boolean getPlay() {
        return this.play;
    }

    public final void setPlay(boolean bl) {
        this.play = bl;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public String getAddress() {
        return this.address;
    }

    public void setAddress(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.address = string;
    }

    @Nullable
    public final Integer getPid() {
        return this.pid;
    }

    public final void setPid(@Nullable Integer n) {
        this.pid = n;
    }

    @NotNull
    public RunConfiguration clone() {
        RunConfiguration runConfiguration = super.clone();
        if (runConfiguration == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.plugins.unity.run.configurations.UnityAttachToEditorConfiguration");
        }
        UnityAttachToEditorConfiguration configuration = (UnityAttachToEditorConfiguration)runConfiguration;
        configuration.pid = this.pid;
        return (RunConfiguration)configuration;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return new UnityAttachToEditorSettingsEditor(project);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        if (Intrinsics.areEqual((Object)executor.getId(), (Object)DefaultDebugExecutor.EXECUTOR_ID) ^ true) {
            return null;
        }
        return (RunProfileState)new UnityAttachToEditorProfileState(this, environment);
    }

    public void checkSettingsBeforeRun() {
        ProcessInfo[] processList = OSProcessUtil.getProcessList();
        Intrinsics.checkExpressionValueIsNotNull((Object)processList, (String)"processList");
        Integer n = this.checkValidEditorInstance(this.pid, processList);
        if (n == null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)processList, (String)"processList");
            n = this.findUnityEditorInstance(processList);
        }
        if (n == null) {
            throw (Throwable)new RuntimeConfigurationError("Cannot find Unity Editor instance");
        }
        Integer n2 = this.pid = Integer.valueOf(n);
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        this.setPort(56000 + n2 % 1000);
    }

    private final Integer checkValidEditorInstance(Integer pid, ProcessInfo[] processList) {
        if (pid != null) {
            boolean bl;
            block3: {
                Object[] $receiver$iv = processList;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    ProcessInfo it = (ProcessInfo)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getPid(), (Object)pid) && UnityProcessUtil.Companion.isUnityEditorProcess(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return pid;
            }
        }
        return null;
    }

    private final Integer findUnityEditorInstance(ProcessInfo[] processList) {
        Integer n = this.findUnityEditorInstanceFromEditorInstanceJson(processList);
        return n != null ? ((Number)n).intValue() : this.findUnityEditorInstanceFromProcesses(processList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Integer findUnityEditorInstanceFromEditorInstanceJson(ProcessInfo[] processList) {
        VirtualFile virtualFile = this.getProject().getBaseDir().findFileByRelativePath("Library/EditorInstance.json");
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile file = virtualFile2 = virtualFile;
            String comment$iv = "Error reading EditorInstance.json";
            try {
                Closeable closeable = file.getInputStream();
                Charset charset = null;
                boolean bl = true;
                Object var8_13 = null;
                if (bl & true) {
                    charset = Charsets.UTF_8;
                }
                closeable = new InputStreamReader((InputStream)closeable, charset);
                boolean bl2 = false;
                try {
                    InputStreamReader reader = (InputStreamReader)closeable;
                    JsonObject jsonObject = new JsonParser().parse((Reader)reader).getAsJsonObject();
                    int processId = jsonObject.get("process_id").getAsInt();
                    Integer n = this.checkValidEditorInstance(processId, processList);
                    return n;
                }
                catch (Exception exception) {
                    bl2 = true;
                    try {
                        closeable.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw (Throwable)exception;
                }
                finally {
                    if (!bl2) {
                        closeable.close();
                    }
                }
            }
            catch (Throwable e$iv) {
                CharSequence charSequence = comment$iv;
                String sfx$iv = StringsKt.isBlank((CharSequence)charSequence) ? "" : ": " + comment$iv;
                LogFactory.getLog((String)"catch").error((Object)("Isolated exception" + sfx$iv), e$iv);
            }
        }
        return null;
    }

    private final int findUnityEditorInstanceFromProcesses(ProcessInfo[] processList) {
        ProcessInfo it;
        Object $receiver$iv$iv;
        Object $receiver$iv = processList;
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            it = (ProcessInfo)element$iv$iv;
            if (!UnityProcessUtil.Companion.isUnityEditorProcess(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it = (ProcessInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            Integer n = it.getPid();
            collection.add(n);
        }
        List pids = (List)destination$iv$iv;
        if (pids.isEmpty()) {
            throw (Throwable)new RuntimeConfigurationError("No Unity Editor instances found");
        }
        if (pids.size() > 1) {
            throw (Throwable)new RuntimeConfigurationError("Multiple Unity Editor instances found");
        }
        return ((Number)pids.get(0)).intValue();
    }

    public void checkConfiguration() {
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.readExternal(element);
        String shouldPlay = element.getAttributeValue("play");
        this.play = shouldPlay != null && Boolean.parseBoolean(shouldPlay);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.writeExternal(element);
        if (this.pid != null) {
            element.setAttribute("pid", String.valueOf(this.pid));
        }
        if (this.play) {
            element.setAttribute("play", String.valueOf(this.play));
        }
    }

    public UnityAttachToEditorConfiguration(@NotNull Project project, @NotNull UnityAttachToEditorFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)factory), (String)"factory");
        super(project, (ConfigurationFactory)factory, "Attach To Unity Editor");
        this.port = -1;
        this.address = "localhost";
    }
}

