/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.SystemClipboard;
import com.sun.glass.ui.win.WinHTMLCodec;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class WinSystemClipboard
extends SystemClipboard {
    private long ptr = 0L;
    static final byte[] terminator;
    static final String defaultCharset = "UTF-16LE";
    static final String RTFCharset = "US-ASCII";

    private static native void initIDs();

    protected WinSystemClipboard(String name) {
        super(name);
        this.create();
    }

    protected final long getPtr() {
        return this.ptr;
    }

    @Override
    protected native boolean isOwner();

    protected native void create();

    protected native void dispose();

    protected native void push(Object[] var1, int var2);

    protected native boolean pop();

    private byte[] fosSerialize(String mime, long index) {
        Pixels pxls;
        Object data = this.getLocalData(mime);
        if (data instanceof ByteBuffer) {
            byte[] b = ((ByteBuffer)data).array();
            if ("text/html".equals(mime)) {
                b = WinHTMLCodec.encode(b);
            }
            return b;
        }
        if (data instanceof String) {
            String st = ((String)data).replace("\n", "\r\n");
            if ("text/html".equals(mime)) {
                try {
                    byte[] bytes = st.getBytes("UTF-8");
                    ByteBuffer ba = ByteBuffer.allocate(bytes.length + 1);
                    ba.put(bytes);
                    ba.put((byte)0);
                    return WinHTMLCodec.encode(ba.array());
                }
                catch (UnsupportedEncodingException ex) {
                    return null;
                }
            }
            if ("text/rtf".equals(mime)) {
                try {
                    byte[] bytes = st.getBytes(RTFCharset);
                    ByteBuffer ba2 = ByteBuffer.allocate(bytes.length + 1);
                    ba2.put(bytes);
                    ba2.put((byte)0);
                    return ba2.array();
                }
                catch (UnsupportedEncodingException ex) {
                    return null;
                }
            }
            ByteBuffer ba = ByteBuffer.allocate((st.length() + 1) * 2);
            try {
                ba.put(st.getBytes(defaultCharset));
            }
            catch (UnsupportedEncodingException ba2) {
                // empty catch block
            }
            ba.put(terminator);
            return ba.array();
        }
        if ("application/x-java-file-list".equals(mime)) {
            String[] ast = (String[])data;
            if (ast != null && ast.length > 0) {
                int size = 0;
                for (String st : ast) {
                    size += (st.length() + 1) * 2;
                }
                size += 2;
                try {
                    ByteBuffer ba2 = ByteBuffer.allocate(size);
                    for (String st : ast) {
                        ba2.put(st.getBytes(defaultCharset));
                        ba2.put(terminator);
                    }
                    ba2.put(terminator);
                    return ba2.array();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        } else if ("application/x-java-rawimage".equals(mime) && (pxls = (Pixels)data) != null) {
            ByteBuffer ba = ByteBuffer.allocate(pxls.getWidth() * pxls.getHeight() * 4 + 8);
            ba.putInt(pxls.getWidth());
            ba.putInt(pxls.getHeight());
            ba.put(pxls.asByteBuffer());
            return ba.array();
        }
        return null;
    }

    @Override
    protected final void pushToSystem(HashMap<String, Object> cacheData, int supportedActions) {
        Set<String> mimes = cacheData.keySet();
        HashSet<String> mimesForSystem = new HashSet<String>();
        MimeTypeParser parser = new MimeTypeParser();
        for (String mime : mimes) {
            parser.parse(mime);
            if (parser.isInMemoryFile()) continue;
            mimesForSystem.add(mime);
        }
        this.push(mimesForSystem.toArray(), supportedActions);
    }

    private native byte[] popBytes(String var1, long var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final Object popFromSystem(String mimeFull) {
        if (!this.pop()) {
            return null;
        }
        MimeTypeParser parser = new MimeTypeParser(mimeFull);
        String mime = parser.getMime();
        byte[] data = this.popBytes(mime, parser.getIndex());
        if (data != null) {
            if ("text/plain".equals(mime) || "text/uri-list".equals(mime)) {
                try {
                    return new String(data, 0, data.length - 2, defaultCharset);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
            if ("text/html".equals(mime)) {
                try {
                    data = WinHTMLCodec.decode(data);
                    return new String(data, 0, data.length, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
            if ("text/rtf".equals(mime)) {
                try {
                    return new String(data, 0, data.length, RTFCharset);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
            if (!"application/x-java-file-list".equals(mime)) {
                if (!"application/x-java-rawimage".equals(mime)) return ByteBuffer.wrap(data);
                ByteBuffer size = ByteBuffer.wrap(data, 0, 8);
                return Application.GetApplication().createPixels(size.getInt(), size.getInt(), ByteBuffer.wrap(data, 8, data.length - 8));
            }
            try {
                String st = new String(data, 0, data.length, defaultCharset);
                return st.split("\u0000");
            }
            catch (UnsupportedEncodingException st) {
                return null;
            }
        }
        if (("text/uri-list".equals(mime) || "text/plain".equals(mime)) && (data = this.popBytes(mime + ";locale", parser.getIndex())) != null) {
            try {
                return new String(data, 0, data.length - 1, "UTF-8");
            }
            catch (UnsupportedEncodingException size) {
                // empty catch block
            }
        }
        if (!"text/uri-list".equals(mime)) return null;
        String[] ret = (String[])this.popFromSystem("application/x-java-file-list");
        if (ret == null) return null;
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < ret.length) {
            String fileName = ret[i];
            fileName = fileName.replace("\\", "/");
            if (out.length() > 0) {
                out.append("\r\n");
            }
            out.append("file:/").append(fileName);
            ++i;
        }
        return out.toString();
    }

    private native String[] popMimesFromSystem();

    @Override
    protected final String[] mimesFromSystem() {
        if (!this.pop()) {
            return null;
        }
        return this.popMimesFromSystem();
    }

    @Override
    public String toString() {
        return "Windows System Clipboard";
    }

    @Override
    protected final void close() {
        this.dispose();
        this.ptr = 0L;
    }

    @Override
    protected native void pushTargetActionToSystem(int var1);

    private native int popSupportedSourceActions();

    @Override
    protected int supportedSourceActionsFromSystem() {
        if (!this.pop()) {
            return 0;
        }
        return this.popSupportedSourceActions();
    }

    static {
        WinSystemClipboard.initIDs();
        terminator = new byte[]{0, 0};
    }

    private static final class MimeTypeParser {
        protected static final String externalBodyMime = "message/external-body";
        protected String mime;
        protected boolean bInMemoryFile;
        protected int index;

        public MimeTypeParser() {
            this.parse("");
        }

        public MimeTypeParser(String mimeFull) {
            this.parse(mimeFull);
        }

        public void parse(String mimeFull) {
            this.mime = mimeFull;
            this.bInMemoryFile = false;
            this.index = -1;
            if (mimeFull.startsWith(externalBodyMime)) {
                String[] mimeParts = mimeFull.split(";");
                String accessType = "";
                int indexValue = -1;
                for (int i = 1; i < mimeParts.length; ++i) {
                    String[] params = mimeParts[i].split("=");
                    if (params.length == 2) {
                        if (params[0].trim().equalsIgnoreCase("index")) {
                            indexValue = Integer.parseInt(params[1].trim());
                        } else if (params[0].trim().equalsIgnoreCase("access-type")) {
                            accessType = params[1].trim();
                        }
                    }
                    if (indexValue != -1 && !accessType.isEmpty()) break;
                }
                if (accessType.equalsIgnoreCase("clipboard")) {
                    this.bInMemoryFile = true;
                    this.mime = mimeParts[0];
                    this.index = indexValue;
                }
            }
        }

        public String getMime() {
            return this.mime;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isInMemoryFile() {
            return this.bInMemoryFile;
        }
    }
}

