/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.Function;
import com.jetbrains.firefox.FirefoxCallFrame;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxSuspendContext;
import com.jetbrains.firefox.FirefoxValueManager;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Frame;
import com.jetbrains.firefox.rdp.FramesResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.debugger.CallFrame;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a-\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\u0010\f\" \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"CALL_FRAMES_LOADER", "Lorg/jetbrains/concurrency/PromiseManager;", "Lcom/jetbrains/firefox/FirefoxSuspendContext;", "", "Lorg/jetbrains/debugger/CallFrame;", "createFrames", "result", "Lcom/jetbrains/firefox/rdp/FramesResult;", "topFrame", "Lcom/jetbrains/firefox/FirefoxCallFrame;", "valueManager", "Lcom/jetbrains/firefox/FirefoxValueManager;", "(Lcom/jetbrains/firefox/rdp/FramesResult;Lcom/jetbrains/firefox/FirefoxCallFrame;Lcom/jetbrains/firefox/FirefoxValueManager;)[Lorg/jetbrains/debugger/CallFrame;", "FirefoxConnector"})
public final class FirefoxSuspendContextKt {
    private static final PromiseManager<FirefoxSuspendContext, CallFrame[]> CALL_FRAMES_LOADER = (PromiseManager)new PromiseManager<FirefoxSuspendContext, CallFrame[]>(FirefoxSuspendContext.class){

        @NotNull
        public Promise<CallFrame[]> load(@NotNull FirefoxSuspendContext context) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
            FirefoxVm vm = context.getVm();
            FirefoxCommandProcessor firefoxCommandProcessor = vm.getCommandProcessor();
            String string = vm.getThreadActor();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.getFrames(string, 1)).then((Function)new Function<T, SUB_RESULT>(context){
                final /* synthetic */ FirefoxSuspendContext $context;

                @NotNull
                public final CallFrame[] fun(FramesResult it) {
                    FramesResult framesResult = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)framesResult, (String)"it");
                    return FirefoxSuspendContextKt.createFrames(framesResult, this.$context.getTopFrame(), this.$context.getValueManager());
                }
                {
                    this.$context = firefoxSuspendContext;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"vm.commandProcessor.send\u2026, context.valueManager) }");
            return promise;
        }
    };

    @NotNull
    public static final CallFrame[] createFrames(@NotNull FramesResult result, @Nullable FirefoxCallFrame topFrame, @NotNull FirefoxValueManager valueManager) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
        int offset = topFrame == null ? 0 : 1;
        CallFrame[] frames = new CallFrame[result.frames().size() + offset];
        if (topFrame != null) {
            frames[0] = (CallFrame)topFrame;
        }
        List<Frame> vmFrames = result.frames();
        boolean useBindingsFromFrameData = topFrame == null;
        int n = vmFrames.size();
        for (int i = 0; i < n; ++i) {
            frames[i + offset] = (CallFrame)new FirefoxCallFrame(valueManager, vmFrames.get(i), useBindingsFromFrameData);
            useBindingsFromFrameData = false;
        }
        return frames;
    }

    @NotNull
    public static final /* synthetic */ PromiseManager access$getCALL_FRAMES_LOADER$p() {
        return CALL_FRAMES_LOADER;
    }
}

