/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.remote.BaseRemoteProcessHandler;
import com.intellij.remote.RemoteProcess;
import com.jetbrains.plugins.remotesdk.transport.JschProcess;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturingRemoteProcessHandler
extends BaseRemoteProcessHandler {
    private static final Logger LOG = Logger.getInstance(CapturingRemoteProcessHandler.class);
    private final ProcessOutput myOutput;

    @Deprecated
    public CapturingRemoteProcessHandler(@NotNull JschProcess process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/plugins/remotesdk/CapturingRemoteProcessHandler", "<init>"));
        }
        this(process, null, "");
    }

    public CapturingRemoteProcessHandler(@NotNull JschProcess process, @Nullable Charset charset, @NotNull String commandLine) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/plugins/remotesdk/CapturingRemoteProcessHandler", "<init>"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/plugins/remotesdk/CapturingRemoteProcessHandler", "<init>"));
        }
        super((RemoteProcess)process, commandLine, charset);
        this.myOutput = new ProcessOutput();
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType == ProcessOutputTypes.STDOUT) {
                    CapturingRemoteProcessHandler.this.myOutput.appendStdout(event.getText());
                }
                if (outputType == ProcessOutputTypes.STDERR) {
                    CapturingRemoteProcessHandler.this.myOutput.appendStderr(event.getText());
                }
            }
        });
    }

    public ProcessOutput runProcess() {
        this.startNotify();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            while (!this.waitFor(300L)) {
                if (!indicator.isCanceled()) continue;
                this.destroyProcess();
                throw new ProcessCanceledException();
            }
        } else if (!this.waitFor()) {
            LOG.info("runProcess: exit value unavailable");
            return this.myOutput;
        }
        this.myOutput.setExitCode(this.getProcess().exitValue());
        return this.myOutput;
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds) {
        if (timeoutInMilliseconds <= 0) {
            return this.runProcess();
        }
        this.startNotify();
        if (this.waitFor(timeoutInMilliseconds)) {
            this.myOutput.setExitCode(this.getProcess().exitValue());
        } else {
            this.destroyProcess();
            this.myOutput.setTimeout();
        }
        return this.myOutput;
    }
}

