/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.config.SftpUserInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteRunUserInfo
implements UserInfo,
UIKeyboardInteractive {
    public static final String TITLE = "Connecting To Remote Host";
    @NotNull
    private final ConnectionOwner myConnectionOwner;
    private RemoteCredentials myData;
    private final ProgressIndicator myProgressIndicator;

    public RemoteRunUserInfo(@NotNull ConnectionOwner connectionOwner, RemoteCredentials data, @Nullable ProgressIndicator pi) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/remotesdk/RemoteRunUserInfo", "<init>"));
        }
        this.myConnectionOwner = connectionOwner;
        this.myData = data;
        this.myProgressIndicator = pi;
    }

    public String getPassphrase() {
        return this.myData.getPassphrase();
    }

    public String getPassword() {
        return this.myData.getPassword();
    }

    public boolean promptPassword(String message) {
        return true;
    }

    public boolean promptPassphrase(String message) {
        return true;
    }

    public boolean promptYesNo(String message) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        return this.myConnectionOwner.promptYesNo(message, TITLE, this.myProgressIndicator);
    }

    public void showMessage(String message) {
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            return;
        }
        this.myConnectionOwner.showMessage(message, TITLE, null, this.myProgressIndicator, null);
    }

    @Nullable
    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        if (prompt.length != 1 || echo[0]) {
            return null;
        }
        if (SftpUserInfo.isPasswordPrompted((String)prompt[0])) {
            String[] stringArray;
            String password = this.myData.getPassword();
            if (password != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = password;
            } else {
                stringArray = null;
            }
            return stringArray;
        }
        if (Registry.is((String)"ide.ssh.one.time.password")) {
            String[] stringArray;
            String password = this.myConnectionOwner.promptPassword(prompt[0], TITLE, this.myProgressIndicator);
            if (password != null) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = password;
            } else {
                stringArray = null;
            }
            return stringArray;
        }
        return null;
    }
}

