/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.google.common.net.HostAndPort;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSshProcess;
import com.jetbrains.plugins.webDeployment.transport.SshChannel;
import com.jetbrains.plugins.webDeployment.transport.SshSession;
import com.jetbrains.plugins.webDeployment.transport.SshTransportException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JschProcess<C extends SshChannel>
extends RemoteSshProcess {
    private static final Logger LOG = Logger.getInstance(JschProcess.class);
    private static final long WAITFOR_TIMEOUT = 5000L;
    private boolean myCtrlCSent;
    private long myCtrlCSentMillis;
    @NotNull
    private final C myChannel;

    public JschProcess(@NotNull C channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/jetbrains/plugins/remotesdk/transport/JschProcess", "<init>"));
        }
        this.myCtrlCSent = false;
        this.myChannel = channel;
    }

    @NotNull
    public C getChannel() {
        C c = this.myChannel;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/JschProcess", "getChannel"));
        }
        return c;
    }

    public InputStream getInputStream() {
        return this.getChannel().getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.getChannel().getOutputStream();
    }

    public boolean isDisconnected() {
        return this.getChannel().isClosed();
    }

    public int exitValue() {
        if (this.isRunning()) {
            throw new IllegalThreadStateException();
        }
        return this.getChannel().getExitStatus();
    }

    private boolean isRunning() {
        return this.getChannel().getExitStatus() < 0 && this.getChannel().isConnected();
    }

    public void destroy() {
        if (this.getChannel().isConnected()) {
            this.getChannel().disconnect();
        }
    }

    public int waitFor() throws InterruptedException {
        while (this.isRunning()) {
            Thread.sleep(100L);
            if (!this.myCtrlCSent || System.currentTimeMillis() - this.myCtrlCSentMillis <= 5000L) continue;
            LOG.warn("Remote process wasn't closed within timeout after Ctrl+C. Disconnecting.");
            this.destroy();
        }
        return this.exitValue();
    }

    public void addRemoteTunnel(int remotePort, String host, int localPort) throws RemoteSdkException {
        try {
            this.myChannel.getSshSession().addRemoteTunnel(remotePort, host, localPort);
        }
        catch (SshTransportException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
    }

    public void addLocalTunnel(int localPort, int remotePort) throws RemoteSdkException {
        try {
            this.myChannel.getSshSession().addLocalTunnel(localPort, this.myChannel.getSshSession().getHost(), remotePort);
        }
        catch (SshTransportException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return this.myChannel.getLocalTunnel(remotePort);
    }

    public void removeLocalTunnel(int localPort) throws RemoteSdkException {
        try {
            this.myChannel.getSshSession().removeLocalTunnel(localPort);
        }
        catch (SshTransportException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean sendCtrlC() {
        try {
            this.getOutputStream().write(3);
            this.getOutputStream().flush();
            this.myCtrlCSent = true;
            this.myCtrlCSentMillis = System.currentTimeMillis();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @NotNull
    public SshSession getSession() {
        SshSession sshSession = this.myChannel.getSshSession();
        if (sshSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/JschProcess", "getSession"));
        }
        return sshSession;
    }
}

