/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.UserInfo;
import com.jetbrains.plugins.remotesdk.RemoteRunUserInfo;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshUtil {
    private static final Logger LOG = Logger.getInstance(SshUtil.class);
    public static final int TIMEOUT = 60;

    /*
     * WARNING - void declaration
     */
    public static Session connectJSch(@NotNull RemoteCredentials data, @NotNull ConnectionOwner connectionOwner, @Nullable ProgressIndicator pi, long timeout, @NotNull TimeUnit timeUnit) throws JSchException {
        void timeUnit2;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshUtil", "connectJSch"));
        }
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/remotesdk/transport/SshUtil", "connectJSch"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeUnit", "com/jetbrains/plugins/remotesdk/transport/SshUtil", "connectJSch"));
        }
        return SshUtil.connectJSch(data, connectionOwner, pi, timeUnit2.toMillis(timeout));
    }

    public static Session connectJSch(@NotNull RemoteCredentials data, @NotNull ConnectionOwner connectionOwner, @Nullable ProgressIndicator pi, long timeoutInMillis) throws JSchException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshUtil", "connectJSch"));
        }
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/remotesdk/transport/SshUtil", "connectJSch"));
        }
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("Invalid timeout value: " + timeoutInMillis);
        }
        if (timeoutInMillis > Integer.MAX_VALUE) {
            timeoutInMillis = Integer.MAX_VALUE;
        }
        JSch jsch = new JSch();
        String knownHosts = SshUtil.getKnownHosts(data);
        if (knownHosts != null) {
            SshUtil.assureKnownHostsFileExists(knownHosts);
            try {
                jsch.setKnownHosts(knownHosts);
            }
            catch (JSchException e) {
                LOG.error("Can't set known hosts file", (Throwable)e);
            }
        }
        JSch.setConfig((String)"HashKnownHosts", (String)"no");
        if (data.isUseKeyPair()) {
            jsch.addIdentity(data.getPrivateKeyFile(), data.getPassphrase());
        }
        Session s = jsch.getSession(data.getUserName(), data.getHost(), data.getPort());
        s.setTimeout((int)timeoutInMillis);
        Properties config = SshUtil.createConfig();
        if (config.size() > 0) {
            s.setConfig(config);
        }
        s.setUserInfo((UserInfo)new RemoteRunUserInfo(connectionOwner, data, pi));
        s.connect((int)timeoutInMillis);
        return s;
    }

    private static void assureKnownHostsFileExists(@NotNull String knownHosts) {
        if (knownHosts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "knownHosts", "com/jetbrains/plugins/remotesdk/transport/SshUtil", "assureKnownHostsFileExists"));
        }
        knownHosts = SshUtil.checkTilde(knownHosts);
        File file = new File(knownHosts);
        try {
            if (file.createNewFile()) {
                LOG.debug("Known hosts file " + knownHosts + " created");
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to create known hosts file", (Throwable)e);
        }
    }

    private static String checkTilde(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/jetbrains/plugins/remotesdk/transport/SshUtil", "checkTilde"));
        }
        try {
            if (str.startsWith("~")) {
                str = str.replace("~", System.getProperty("user.home"));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return str;
    }

    private static Properties createConfig() {
        Properties config = new Properties();
        config.setProperty("compression.s2c", "zlib,none");
        config.setProperty("compression.c2s", "zlib,none");
        return config;
    }

    @Nullable
    private static String getKnownHosts(@NotNull RemoteCredentials data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshUtil", "getKnownHosts"));
        }
        String knownHosts = !StringUtil.isEmpty((String)data.getKnownHostsFile()) ? data.getKnownHostsFile() : SshUtil.findKnownHostsPath();
        return knownHosts;
    }

    public static ChannelSftp createSftpChannel(@NotNull Session session) throws JSchException {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/plugins/remotesdk/transport/SshUtil", "createSftpChannel"));
        }
        ChannelSftp chan = (ChannelSftp)session.openChannel("sftp");
        assert (!chan.isClosed());
        chan.connect(60000);
        return chan;
    }

    @Nullable
    public static SftpATTRS getAttrs(@NotNull ChannelSftp channel, @NotNull String path) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/jetbrains/plugins/remotesdk/transport/SshUtil", "getAttrs"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/remotesdk/transport/SshUtil", "getAttrs"));
        }
        try {
            return channel.lstat(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static File findKnownHosts() {
        File sshDir = SshUtil.findSshDir();
        if (sshDir != null) {
            return new File(sshDir, "known_hosts");
        }
        return null;
    }

    @Nullable
    public static String findKnownHostsPath() {
        File knownHosts = SshUtil.findKnownHosts();
        if (knownHosts != null) {
            return knownHosts.getPath();
        }
        return null;
    }

    @Nullable
    public static File findSshDir() {
        String SSH_DIR_NAME = ".ssh";
        File sshDir = new File(System.getProperty("user.home"), SSH_DIR_NAME);
        if (sshDir.exists()) {
            return sshDir;
        }
        if (SystemInfo.isWindows) {
            String userName = System.getProperty("user.name");
            sshDir = new File("C:\\cygwin\\home\\" + userName + "\\" + SSH_DIR_NAME);
            if (sshDir.exists()) {
                return sshDir;
            }
        }
        return null;
    }
}

