/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.telemetry.TfsTelemetryHelper;
import java.util.Map;
import javax.swing.Icon;

public abstract class InstrumentedAction
extends DumbAwareAction {
    private final boolean actionUsesGitExe;

    protected InstrumentedAction() {
        this.actionUsesGitExe = true;
    }

    protected InstrumentedAction(boolean usesGitExe) {
        this.actionUsesGitExe = usesGitExe;
    }

    protected InstrumentedAction(String text) {
        super(text);
        this.actionUsesGitExe = true;
    }

    protected InstrumentedAction(String text, String description, Icon icon) {
        super(text, description, icon);
        this.actionUsesGitExe = true;
    }

    protected InstrumentedAction(String text, String description, Icon icon, boolean usesGitExe) {
        super(text, description, icon);
        this.actionUsesGitExe = usesGitExe;
    }

    protected String getActionName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected TfsTelemetryHelper.PropertyMapBuilder getContextProperties() {
        String actionName = this.getActionName();
        return new TfsTelemetryHelper.PropertyMapBuilder().actionName(actionName);
    }

    public abstract void doUpdate(AnActionEvent var1);

    public abstract void doActionPerformed(AnActionEvent var1);

    public final void update(AnActionEvent anActionEvent) {
        try {
            this.doUpdate(anActionEvent);
        }
        catch (Exception ex) {
            TfsTelemetryHelper.sendExceptionAsync((Exception)ex, (Map)this.getContextProperties().build());
        }
    }

    public final void actionPerformed(AnActionEvent anActionEvent) {
        if (anActionEvent != null && anActionEvent.getProject() != null && this.actionUsesGitExe && !IdeaHelper.isGitExeConfigured(anActionEvent.getProject())) {
            return;
        }
        try {
            this.SendStartActionEvent();
            this.doActionPerformed(anActionEvent);
        }
        catch (Exception ex) {
            TfsTelemetryHelper.sendExceptionAsync((Exception)ex, (Map)this.getContextProperties().build());
        }
    }

    private void SendStartActionEvent() {
        String eventName = this.getActionName();
        TfsTelemetryHelper.sendEventAsync((String)eventName, (Map)this.getContextProperties().build());
    }
}

