/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.services;

import com.intellij.openapi.project.ProjectManager;
import com.intellij.vcsUtil.AuthDialog;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextBuilder;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.services.CredentialsPrompt;

public class CredentialsPromptImpl
implements CredentialsPrompt {
    private String userName;
    private String password;
    private boolean promptSuccess;

    public boolean prompt(final String serverUrl, final String defaultUserName) {
        this.promptSuccess = false;
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                CredentialsPromptImpl.this.promptSuccess = CredentialsPromptImpl.this.promptInternal(serverUrl, defaultUserName);
            }
        }, true);
        return this.promptSuccess;
    }

    private boolean promptInternal(String serverUrl, String defaultUserName) {
        AuthDialog authDialog = new AuthDialog(ProjectManager.getInstance().getDefaultProject(), TfPluginBundle.message("Prompt.Credentials.Title", new Object[0]), TfPluginBundle.message("Prompt.Credentials.Message", serverUrl), defaultUserName, null, true);
        if (authDialog.showAndGet()) {
            this.userName = authDialog.getUsername();
            this.password = authDialog.getPassword();
            return true;
        }
        return false;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String validateCredentials(String serverUrl, AuthenticationInfo authenticationInfo) {
        ServerContext context = new ServerContextBuilder().type(ServerContext.Type.TFS).uri(serverUrl).authentication(authenticationInfo).build();
        ServerContextManager.getInstance().validateServerConnection(context);
        return serverUrl;
    }
}

