/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.services;

import com.microsoft.alm.auth.oauth.DeviceFlowResponse;
import com.microsoft.alm.helpers.Action;
import com.microsoft.alm.plugin.idea.common.ui.authentication.DeviceFlowResponsePromptDialog;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.services.DeviceFlowResponsePrompt;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;

public class DeviceFlowResponsePromptImpl
implements DeviceFlowResponsePrompt {
    public Action<DeviceFlowResponse> getCallback(final Action<String> cancellationCallback) {
        return new Action<DeviceFlowResponse>(){

            public void call(final DeviceFlowResponse deviceFlowResponse) {
                IdeaHelper.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DeviceFlowResponsePromptDialog promptDialog = new DeviceFlowResponsePromptDialog();
                        promptDialog.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if ("cancel".equals(e.getActionCommand())) {
                                    deviceFlowResponse.requestCancel();
                                    cancellationCallback.call((Object)"User cancelled the device flow dialog.");
                                } else if ("ok".equals(e.getActionCommand())) {
                                    deviceFlowResponse.getExpiresAt().setTime(new Date());
                                    deviceFlowResponse.getExpiresAt().add(13, 5);
                                }
                            }
                        });
                        promptDialog.setResponse(deviceFlowResponse);
                        promptDialog.show();
                    }
                }, true);
            }
        };
    }
}

