/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.services;

import com.intellij.util.net.HttpConfigurable;
import com.microsoft.alm.common.utils.SystemHelper;
import com.microsoft.alm.plugin.idea.common.utils.BackCompatibleUtils;
import com.microsoft.alm.plugin.services.HttpProxyService;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyServiceImpl
implements HttpProxyService {
    private static final Logger logger = LoggerFactory.getLogger(HttpProxyServiceImpl.class);
    private static final String PROP_PROXY_SET = "proxySet";
    private static final String PROP_PROXY_HOST = "proxyHost";
    private static final String PROP_PROXY_PORT = "proxyPort";
    private static final String PROXY_URL_FORMAT = "http://%s:%d";
    private boolean useHttpProxyViaSystemProperties;
    private boolean useHttpProxyViaIntelliJProperties;

    private void initialize() {
        this.useHttpProxyViaSystemProperties = StringUtils.equalsIgnoreCase((String)System.getProperty(PROP_PROXY_SET), (String)"true");
        this.useHttpProxyViaIntelliJProperties = !this.useHttpProxyViaSystemProperties ? PluginServiceProvider.getInstance().isInsideIDE() && HttpConfigurable.getInstance() != null && HttpConfigurable.getInstance().USE_HTTP_PROXY : false;
    }

    public boolean useHttpProxy() {
        this.initialize();
        logger.info("useHttpProxy: " + (this.useHttpProxyViaSystemProperties || this.useHttpProxyViaIntelliJProperties));
        return this.useHttpProxyViaSystemProperties || this.useHttpProxyViaIntelliJProperties;
    }

    public boolean isAuthenticationRequired() {
        this.initialize();
        boolean result = !this.useHttpProxyViaSystemProperties && this.useHttpProxyViaIntelliJProperties && HttpConfigurable.getInstance().PROXY_AUTHENTICATION;
        logger.info("isAuthenticationRequired: " + result);
        return result;
    }

    public String getProxyURL() {
        String result = String.format(PROXY_URL_FORMAT, this.getProxyHost(), this.getProxyPort());
        logger.info("getProxyURL: " + result);
        return result;
    }

    public String getProxyHost() {
        this.initialize();
        String proxyHost = "127.0.0.1";
        if (this.useHttpProxyViaSystemProperties && System.getProperty(PROP_PROXY_HOST) != null) {
            proxyHost = System.getProperty(PROP_PROXY_HOST);
        } else if (this.useHttpProxyViaIntelliJProperties) {
            proxyHost = HttpConfigurable.getInstance().PROXY_HOST;
        }
        logger.info("getProxyHost: " + proxyHost);
        return proxyHost;
    }

    public int getProxyPort() {
        this.initialize();
        int proxyPort = 8888;
        if (this.useHttpProxyViaSystemProperties && System.getProperty(PROP_PROXY_PORT) != null) {
            proxyPort = SystemHelper.toInt((String)System.getProperty(PROP_PROXY_PORT), (int)proxyPort);
        } else if (this.useHttpProxyViaIntelliJProperties) {
            proxyPort = HttpConfigurable.getInstance().PROXY_PORT;
        }
        logger.info("getProxyPort: " + proxyPort);
        return proxyPort;
    }

    public String getUserName() {
        this.initialize();
        String result = this.useHttpProxyViaIntelliJProperties ? BackCompatibleUtils.getProxyLogin() : null;
        logger.info("getUserName: " + result);
        return result;
    }

    public String getPassword() {
        logger.info("getPassword called");
        this.initialize();
        if (this.useHttpProxyViaIntelliJProperties) {
            return HttpConfigurable.getInstance().getPlainProxyPassword();
        }
        return null;
    }
}

