/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.services;

import com.microsoft.alm.plugin.exceptions.LocalizedException;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.external.exceptions.ToolException;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.services.LocalizationService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LocalizationServiceImpl
implements LocalizationService {
    private static final Map<String, String> keysMap = new HashMap<String, String>(){
        {
            this.put(TeamServicesException.KEY_TFS_UNSUPPORTED_VERSION, "TFS.UnsupportedVersion");
            this.put(TeamServicesException.KEY_VSO_AUTH_SESSION_EXPIRED, "VSO.Auth.SessionExpired");
            this.put(TeamServicesException.KEY_VSO_AUTH_FAILED, "VSO.Auth.Failed");
            this.put(TeamServicesException.KEY_TFS_AUTH_FAILED, "TFS.Auth.Failed");
            this.put(TeamServicesException.KEY_OPERATION_ERRORS, "Operation.Lookup.Errors");
            this.put(TeamServicesException.KEY_VSO_NO_PROFILE_ERROR, "VSO.NoProfileError");
            this.put(TeamServicesException.KEY_TFS_MALFORMED_SERVER_URI, "TFS.MalformedServerUri");
            this.put(TeamServicesException.KEY_ERROR_UNKNOWN, "Errors.Unknown");
            this.put(ToolException.KEY_TF_BAD_EXIT_CODE, "ToolException.TF.BadExitCode");
            this.put(ToolException.KEY_TF_HOME_NOT_SET, "ToolException.TF.HomeNotSet");
            this.put(ToolException.KEY_TF_EXE_NOT_FOUND, "ToolException.TF.ExeNotFound");
            this.put(ToolException.KEY_TF_PARSE_FAILURE, "ToolException.TF.ParseFailure");
            this.put(ToolException.KEY_TF_MIN_VERSION_WARNING, "ToolException.TF.MinVersionWarning");
            this.put(ToolException.KEY_TF_WORKSPACE_EXISTS, "ToolException.TF.WorkspaceExists");
            this.put(ToolException.KEY_TF_BRANCH_EXISTS, "ToolException.TF.BranchExists");
            this.put(ToolException.KEY_TF_OOM, "ToolException.TF.OOM");
        }
    };

    public static LocalizationServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    protected LocalizationServiceImpl() {
    }

    public String getLocalizedMessage(String key, Object ... params) {
        return TfPluginBundle.message(key, params);
    }

    public String getExceptionMessage(Throwable t) {
        LocalizedException localizedException;
        String key;
        String message = t.getLocalizedMessage();
        if (t instanceof LocalizedException && keysMap.containsKey(key = (localizedException = (LocalizedException)t).getMessageKey())) {
            message = this.getLocalizedMessage(keysMap.get(key), localizedException.getMessageParameters());
        }
        if (StringUtils.isEmpty((String)message) && t.getCause() != null) {
            if (t.getCause() instanceof LocalizedException) {
                localizedException = (LocalizedException)t.getCause();
                key = localizedException.getMessageKey();
                if (keysMap.containsKey(key)) {
                    message = this.getLocalizedMessage(keysMap.get(key), localizedException.getMessageParameters());
                }
            } else {
                message = t.getCause().getLocalizedMessage();
            }
        }
        if (StringUtils.isEmpty((String)message)) {
            message = t.toString();
        }
        return message;
    }

    private static class Holder {
        private static LocalizationServiceImpl INSTANCE = new LocalizationServiceImpl();

        private Holder() {
        }
    }
}

