/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.services;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.microsoft.alm.plugin.services.PluginContextInitializer;
import com.microsoft.alm.plugin.telemetry.TfsTelemetryInstrumentationInfo;
import com.microsoft.applicationinsights.extensibility.context.ComponentContext;
import com.microsoft.applicationinsights.extensibility.context.ContextTagKeys;
import com.microsoft.applicationinsights.extensibility.context.DeviceContext;
import com.microsoft.applicationinsights.extensibility.context.SessionContext;
import com.microsoft.applicationinsights.extensibility.context.UserContext;
import com.microsoft.applicationinsights.telemetry.TelemetryContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryContextInitializer
implements PluginContextInitializer {
    private static final Logger logger = LoggerFactory.getLogger(TelemetryContextInitializer.class);
    private static final String DEFAULT_VERSION = "0";
    private static final String LINUX_DISTRIBUTION_NAME = "NAME=";
    private static final String LINUX_DISTRIBUTION_VERSION = "VERSION=";
    private static final String LINUX_OS_NAME = "Linux";
    private static final String SYS_PROP_OS_NAME = "os.name";
    private static final String SYS_PROP_OS_VERSION = "os.version";
    private static final String SYS_PROP_OS_ARCH = "os.arch";
    private static final String SYS_PROP_USER_NAME = "user.name";
    private static final String SYS_PROP_JAVA_RUNTIME = "java.runtime.name";
    private static final String SYS_PROP_JAVA_VERSION = "java.version";
    private static final String USER_AGENT_FORMAT = "VSTSIntelliJ/{0} ({1}; {2}; {3}/{4}) {5}";
    private String linuxDistribution = "";
    private String hostname = "";
    private boolean isInitialized = false;

    public void initialize(TelemetryContext context) {
        if (!this.isInitialized) {
            logger.info("Starting TelemetryContext initialization");
            this.initializeInstrumentationKey(context);
            this.initializeProperties(context.getProperties());
            this.initializeUser(context.getUser());
            this.initializeComponent(context.getComponent());
            this.initializeDevice(context.getDevice());
            this.initializeTags(context.getTags());
            this.initializeSession(context.getSession());
            this.isInitialized = true;
            logger.info("Ending TelemetryContext initialization");
        }
    }

    public String getUserAgent(String defaultUserAgent) {
        try {
            return MessageFormat.format(USER_AGENT_FORMAT, this.getPluginVersion(), this.getApplicationIdentifier(), this.getPlatformFullName(), this.getJavaName(), this.getJavaVersion(), defaultUserAgent);
        }
        catch (Throwable t) {
            logger.warn("Error getting UserAgent", t);
            return defaultUserAgent;
        }
    }

    private void initializeDevice(DeviceContext device) {
        device.setOperatingSystem(this.getPlatformName());
        device.setOperatingSystemVersion(this.getPlatformVersion());
    }

    private void initializeInstrumentationKey(TelemetryContext context) {
        context.setInstrumentationKey(TfsTelemetryInstrumentationInfo.getInstance().getInstrumentationKey());
    }

    private void initializeUser(UserContext user) {
        user.setId(this.getUserId());
        user.setUserAgent("com.microsoft.alm.plugin.idea.ui.tfplugin");
    }

    private String getUserId() {
        String computerName = this.getComputerName();
        String userName = this.getSystemProperty(SYS_PROP_USER_NAME);
        String fakeUserId = MessageFormat.format("{0}@{1}", userName, computerName);
        return DigestUtils.sha1Hex((String)fakeUserId);
    }

    private String getComputerName() {
        if (StringUtils.isEmpty((String)this.hostname)) {
            this.hostname = "unknown";
            try {
                InetAddress address = InetAddress.getLocalHost();
                this.hostname = address.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.hostname;
    }

    private void initializeComponent(ComponentContext component) {
        component.setVersion(this.getPluginVersion());
    }

    private void initializeTags(Map<String, String> tags) {
        tags.put(ContextTagKeys.getKeys().getApplicationId(), "com.microsoft.alm.plugin.idea.ui.tfplugin");
        tags.put(ContextTagKeys.getKeys().getDeviceOS(), this.getPlatformName());
        tags.put(ContextTagKeys.getKeys().getDeviceOSVersion(), this.getPlatformVersion());
    }

    private void initializeSession(SessionContext sessionContext) {
        sessionContext.setId(UUID.randomUUID().toString());
    }

    private void initializeProperties(Map<String, String> properties) {
        properties.put("Context.Default.VSO.Core.user.id", this.getUserId());
        ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
        properties.put("Context.Default.VSO.Core.MajorVersion", appInfo.getMajorVersion());
        properties.put("Context.Default.VSO.Core.MinorVersion", appInfo.getMinorVersion());
        properties.put("Context.Default.VSO.Core.BuildNumber", appInfo.getBuild().asString());
        properties.put("Context.Default.VSO.Core.ExeName", appInfo.getFullApplicationName());
        properties.put("Context.Plugin.Version", this.getPluginVersion());
        properties.put("Context.Default.VSO.Core.Machine.Processor.Architecture", this.getProcessorArchitecture());
        properties.put("Context.Default.VSO.Core.Locale.SystemLocaleName", this.getLocaleName());
        properties.put("Context.Default.VSO.Core.OS.MajorVersion", this.getPlatformMajorVersion());
        properties.put("Context.Default.VSO.Core.OS.MinorVersion", this.getPlatformMinorVersion());
        properties.put("Context.Default.VSO.Core.OS.Name", this.getPlatformName());
        properties.put("Context.Default.VSO.Core.OS.ShortName", this.getPlatformShortName());
        properties.put("Context.Default.VSO.Core.OS.FullName", this.getPlatformFullName());
        properties.put("Context.Default.VSO.Core.Java.Name", this.getJavaName());
        properties.put("Context.Default.VSO.Core.Java.Version", this.getJavaVersion());
    }

    private String getApplicationIdentifier() {
        ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
        return MessageFormat.format("{0}/{1}.{2}.{3}", appInfo.getFullApplicationName(), appInfo.getMajorVersion(), appInfo.getMinorVersion(), appInfo.getBuild().asString());
    }

    private String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName, "");
    }

    private String getPlatformName() {
        return this.getSystemProperty(SYS_PROP_OS_NAME);
    }

    private String getPlatformShortName() {
        String shortName;
        String osName = this.getSystemProperty(SYS_PROP_OS_NAME);
        if (StringUtils.isEmpty((String)osName)) {
            shortName = "";
        } else {
            String[] nameParts = osName.trim().split(" ", 2);
            shortName = nameParts[0];
        }
        return shortName;
    }

    private String getPlatformVersion() {
        return this.getSystemProperty(SYS_PROP_OS_VERSION);
    }

    private String getPlatformMajorVersion() {
        String osVersion = this.getSystemProperty(SYS_PROP_OS_VERSION);
        if (osVersion.indexOf(46) < 0) {
            return osVersion;
        }
        return osVersion.split("\\.", 2)[0];
    }

    private String getPlatformMinorVersion() {
        String osVersion = this.getSystemProperty(SYS_PROP_OS_VERSION);
        if (osVersion.indexOf(46) < 0) {
            return "";
        }
        return osVersion.split("\\.", 2)[1];
    }

    private String getPlatformFullName() {
        return MessageFormat.format("{0} ({1})", this.getSystemProperty(SYS_PROP_OS_NAME), LINUX_OS_NAME.equalsIgnoreCase(this.getPlatformName()) ? this.getLinuxDistribution() : this.getSystemProperty(SYS_PROP_OS_VERSION));
    }

    private String getLinuxDistribution() {
        if (StringUtils.isEmpty((String)this.linuxDistribution)) {
            this.linuxDistribution = this.findLinuxDistribution();
        }
        return this.linuxDistribution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String findLinuxDistribution() {
        BufferedReader bufferedReader;
        String version;
        String distribution;
        block13: {
            String line;
            String[] commands = new String[]{"/bin/sh", "-c", "cat /etc/*-release"};
            distribution = "unknown";
            version = "unknown";
            bufferedReader = null;
            Process process = Runtime.getRuntime().exec(commands);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith(LINUX_DISTRIBUTION_NAME)) {
                    distribution = line.replaceFirst(LINUX_DISTRIBUTION_NAME, "").replace("\"", "");
                }
                if (!line.startsWith(LINUX_DISTRIBUTION_VERSION)) continue;
                version = line.replaceFirst(LINUX_DISTRIBUTION_VERSION, "").replace("\"", "");
            }
            if (bufferedReader == null) break block13;
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                logger.warn("Could not close buffered reader", (Throwable)e);
            }
        }
        return MessageFormat.format("{0} - {1}", distribution, version);
        catch (Exception e) {
            block14: {
                try {
                    logger.warn("Could not find Linux distribution due to error", (Throwable)e);
                    if (bufferedReader == null) break block14;
                }
                catch (Throwable throwable) {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e2) {
                            logger.warn("Could not close buffered reader", (Throwable)e2);
                        }
                    }
                    return MessageFormat.format("{0} - {1}", distribution, version);
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException e3) {
                    logger.warn("Could not close buffered reader", (Throwable)e3);
                }
            }
            return MessageFormat.format("{0} - {1}", distribution, version);
        }
    }

    private String getProcessorArchitecture() {
        return this.getSystemProperty(SYS_PROP_OS_ARCH).toUpperCase();
    }

    private String getLocaleName() {
        return Locale.getDefault().getDisplayName();
    }

    private String getJavaName() {
        return this.getSystemProperty(SYS_PROP_JAVA_RUNTIME);
    }

    private String getJavaVersion() {
        return this.getSystemProperty(SYS_PROP_JAVA_VERSION);
    }

    private String getPluginVersion() {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin((PluginId)PluginId.getId((String)"com.microsoft.vso.idea"));
        String v = plugin != null ? plugin.getVersion() : DEFAULT_VERSION;
        return StringUtils.isNotEmpty((String)v) ? v : DEFAULT_VERSION;
    }
}

