/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.settings;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.settings.JsonHelper;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamServicesSecrets {
    private static final Logger logger = LoggerFactory.getLogger(TeamServicesSecrets.class);

    public static void forget(String key) {
        TeamServicesSecrets.forgetPassword(key);
    }

    public static AuthenticationInfo load(String key) throws IOException {
        String authInfoSerialized = TeamServicesSecrets.readPassword(key);
        AuthenticationInfo info = null;
        if (StringUtils.isNotEmpty((String)authInfoSerialized)) {
            info = JsonHelper.read(authInfoSerialized, AuthenticationInfo.class);
        }
        if (info == null) {
            TeamServicesSecrets.forget(key);
            logger.warn("getServerContextSecrets: info was null for key: ", (Object)key);
            return null;
        }
        return info;
    }

    public static void save(ServerContext context) {
        if (context == null) {
            return;
        }
        String key = context.getKey();
        AuthenticationInfo authenticationInfo = context.getAuthenticationInfo();
        String stringValue = JsonHelper.write(authenticationInfo);
        TeamServicesSecrets.writePassword(key, stringValue);
    }

    public static void forgetPassword(String key) {
        try {
            PasswordSafe.getInstance().removePassword(null, TeamServicesSecrets.class, key);
        }
        catch (PasswordSafeException e) {
            logger.warn("Failed to clear password store", (Throwable)e);
        }
        catch (Throwable t) {
            logger.warn("Failed to clear password store", t);
        }
    }

    public static void writePassword(String key, String value) {
        try {
            PasswordSafe.getInstance().storePassword(null, TeamServicesSecrets.class, key, value);
        }
        catch (PasswordSafeException e) {
            logger.warn("Failed to write password", (Throwable)e);
        }
        catch (Throwable t) {
            logger.warn("Failed to write password", t);
        }
    }

    public static String readPassword(String key) {
        String password = "";
        try {
            password = PasswordSafe.getInstance().getPassword(null, TeamServicesSecrets.class, key);
        }
        catch (PasswordSafeException e) {
            logger.warn("Failed to read password", (Throwable)e);
        }
        catch (Throwable t) {
            logger.warn("Failed to read password", t);
        }
        return password;
    }
}

