/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.setup;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.idea.Main;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.util.containers.HashMap;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.authentication.AuthTypes;
import com.microsoft.alm.plugin.events.ServerPollingManager;
import com.microsoft.alm.plugin.idea.common.services.CredentialsPromptImpl;
import com.microsoft.alm.plugin.idea.common.services.DeviceFlowResponsePromptImpl;
import com.microsoft.alm.plugin.idea.common.services.HttpProxyServiceImpl;
import com.microsoft.alm.plugin.idea.common.services.IdeaAsyncService;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.idea.common.services.PropertyServiceImpl;
import com.microsoft.alm.plugin.idea.common.services.ServerContextStoreImpl;
import com.microsoft.alm.plugin.idea.common.services.TelemetryContextInitializer;
import com.microsoft.alm.plugin.idea.common.setup.LinuxStartup;
import com.microsoft.alm.plugin.idea.common.setup.MacStartup;
import com.microsoft.alm.plugin.idea.common.setup.ProjectRepoEventManager;
import com.microsoft.alm.plugin.idea.common.setup.WindowsStartup;
import com.microsoft.alm.plugin.idea.common.statusBar.StatusBarManager;
import com.microsoft.alm.plugin.services.AsyncService;
import com.microsoft.alm.plugin.services.CredentialsPrompt;
import com.microsoft.alm.plugin.services.DeviceFlowResponsePrompt;
import com.microsoft.alm.plugin.services.HttpProxyService;
import com.microsoft.alm.plugin.services.LocalizationService;
import com.microsoft.alm.plugin.services.PluginContextInitializer;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import com.microsoft.alm.plugin.services.PropertyService;
import com.microsoft.alm.plugin.services.ServerContextStore;
import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationStartup
implements ApplicationComponent {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationStartup.class);
    private static final String CLASS_EXTENSION = ".class";
    private static final String USER_HOME_DIR = System.getProperty("user.home");
    private static final String VSTS_DIR = ".vsts";
    private static final String LOCATION_FILE = "locations.csv";
    private static final String LINUX_EXE_DIR = "bin";
    private static final String MAC_EXE_DIR = "MacOS";
    private static final String CSV_COMMA = ",";

    public void initComponent() {
        PluginServiceProvider.getInstance().initialize((ServerContextStore)new ServerContextStoreImpl(), (CredentialsPrompt)new CredentialsPromptImpl(), (DeviceFlowResponsePrompt)new DeviceFlowResponsePromptImpl(), (PluginContextInitializer)new TelemetryContextInitializer(), (PropertyService)PropertyServiceImpl.getInstance(), (LocalizationService)LocalizationServiceImpl.getInstance(), (HttpProxyService)new HttpProxyServiceImpl(), (AsyncService)new IdeaAsyncService(), true);
        File vstsDirectory = this.setupPreferenceDir(USER_HOME_DIR);
        String ideLocation = this.getIdeLocation();
        this.doOsSetup(vstsDirectory, ideLocation);
        StatusBarManager.setupStatusBar();
        ProjectRepoEventManager.getInstance().startListening();
        ServerPollingManager.getInstance().startPolling();
        this.configureAuthType();
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        return "ApplicationStartup";
    }

    protected File setupPreferenceDir(String parentDirectory) {
        File parent = new File(parentDirectory);
        File vstsDirectory = new File(parent, VSTS_DIR);
        if (!vstsDirectory.exists()) {
            vstsDirectory.mkdir();
        }
        return vstsDirectory;
    }

    protected String getIdeLocation() {
        String resourcePath = Main.class.getResource(Main.class.getSimpleName() + CLASS_EXTENSION).getPath();
        Pattern pattern = Pattern.compile("file:(.*?)lib/bootstrap.jar!/" + Main.class.getName() + CLASS_EXTENSION);
        Matcher matcher = pattern.matcher(resourcePath);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheIdeLocation(File vstsDirectory, String currentLocation) {
        HashMap locationEntries = new HashMap();
        File locationsFile = new File(vstsDirectory, LOCATION_FILE);
        String ideName = ApplicationNamesInfo.getInstance().getProductName().toLowerCase();
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String currentEntry = "";
        try {
            if (!locationsFile.exists()) {
                locationsFile.createNewFile();
            } else {
                Object line;
                bufferedReader = new BufferedReader(new FileReader(locationsFile));
                while ((line = bufferedReader.readLine()) != null) {
                    String[] entry = ((String)line).split(CSV_COMMA);
                    if (entry.length != 2) continue;
                    if (ideName.equals(entry[0])) {
                        currentEntry = entry[1];
                    }
                    locationEntries.put(entry[0], entry[1]);
                }
                bufferedReader.close();
            }
            if (!currentEntry.equals(currentLocation) && !currentLocation.isEmpty()) {
                if (!currentEntry.isEmpty()) {
                    locationEntries.remove(ideName);
                }
                locationEntries.put(ideName, currentLocation);
                bufferedWriter = new BufferedWriter(new FileWriter(locationsFile.getPath()));
                for (String key : locationEntries.keySet()) {
                    bufferedWriter.write(key + CSV_COMMA + (String)locationEntries.get(key) + "\n");
                }
                bufferedWriter.close();
            }
        }
        catch (FileNotFoundException e) {
            logger.warn("A FileNotFoundException was caught while trying to cache the IDE location", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("An IOException was caught while trying to cache the IDE location", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("An Exception was caught while trying to cache the IDE location", (Throwable)e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException e) {
                logger.warn("An IOException was caught while trying to close the buffered reader/writer", (Throwable)e);
            }
        }
    }

    protected void doOsSetup(File vstsDirectory, String ideLocation) {
        if (Platform.isWindows()) {
            logger.debug("Windows operating system detected");
            WindowsStartup.startup();
        } else if (Platform.isMac()) {
            logger.debug("Mac operating system detected");
            this.cacheIdeLocation(vstsDirectory, ideLocation + MAC_EXE_DIR);
            MacStartup.startup();
        } else {
            logger.debug("Linux operating system detected ");
            this.cacheIdeLocation(vstsDirectory, ideLocation + LINUX_EXE_DIR);
            LinuxStartup.startup();
        }
    }

    @VisibleForTesting
    protected void configureAuthType() {
        if (AuthHelper.isAuthTypeFromSettingsFileSet()) {
            AuthHelper.setDeviceFlowEnvFromSettingsFile();
        } else if (AuthHelper.isDeviceFlowEnvSetTrue()) {
            AuthHelper.setAuthTypeInSettingsFile((AuthTypes)AuthTypes.DEVICE_FLOW);
        }
    }
}

