/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.setup;

import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxStartup {
    private static final Logger logger = LoggerFactory.getLogger(LinuxStartup.class);
    private static final String UPDATE_LOCAL_DESKTOP_DB_CMD = "update-desktop-database " + System.getProperty("user.home") + "/.local/share/applications/";
    private static final File USER_HOME = new File(System.getProperty("user.home"));
    private static final String VSOI_DESKTOP_FILE_PATH = ".local/share/applications/vsoi.desktop";
    private static final String SCRIPT_NAME = "vsts.sh";
    private static final String LINUX_DIR = "linux";

    public static void startup() {
        try {
            File script = new File(IdeaHelper.getResourcePath(LinuxStartup.class.getResource("/"), SCRIPT_NAME, LINUX_DIR));
            IdeaHelper.setExecutablePermissions(script);
            LinuxStartup.createDesktopFile(script, new File(USER_HOME, VSOI_DESKTOP_FILE_PATH));
            Process process = Runtime.getRuntime().exec(UPDATE_LOCAL_DESKTOP_DB_CMD);
            process.waitFor();
            logger.debug("The return code for executing update-desktop-database was {}", (Object)process.exitValue());
        }
        catch (IOException e) {
            logger.warn("An IOException was caught while trying to run the Linux startup steps: {}", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            logger.warn("An InterruptedException was caught while waiting for the database desktop to update: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.warn("An Exception was caught while trying to run the Linux startup steps", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File createDesktopFile(File scriptFile, File desktopFile) throws IOException {
        FileWriter fileWriter = new FileWriter(desktopFile);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        try {
            bufferedWriter.write("[Desktop Entry]\nName=VSTS Protocol Handler\nComment=Custom protocol handler for the IntelliJ VSTS plugin\nExec=" + scriptFile.getAbsolutePath() + " %u\n" + "Icon=\n" + "Terminal=False\n" + "Type=Application\n" + "X-MultipleArgs=True\n" + "MimeType=x-scheme-handler/vsoi\n" + "Encoding=UTF-8\n" + "Categories=Network;Application;");
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        return desktopFile;
    }
}

