/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.starters;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.starters.ApplicationStarterBase;
import com.microsoft.alm.plugin.idea.git.starters.SimpleCheckoutStarter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VstsStarter
extends ApplicationStarterBase {
    private final Logger logger = LoggerFactory.getLogger(VstsStarter.class);
    private static final String IDE_TYPE_ATTRIBUTE = "IdeType";
    private static final String IDE_EXE_ATTRIBUTE = "IdeExe";

    @Override
    public String getUsageMessage() {
        String applicationType = ApplicationNamesInfo.getInstance().getScriptName();
        return TfPluginBundle.message("Starter.Usage.Message", "vsts", applicationType);
    }

    @Override
    protected void processCommand(List<String> args) throws RuntimeException {
        String command = args.remove(0);
        if (!StringUtils.equalsIgnoreCase((String)"checkout", (String)command)) {
            throw new RuntimeException(TfPluginBundle.message("Starter.Errors.SubCommandNotRecognized", command));
        }
        SimpleCheckoutStarter starter = SimpleCheckoutStarter.createWithCommandLineArgs(args);
        starter.processCommand();
    }

    @Override
    protected void processUri(String uri) throws RuntimeException, UnsupportedEncodingException {
        String[] args = uri.split("/\\?");
        if (args.length != 2) {
            throw new RuntimeException(TfPluginBundle.message("Starter.Errors.MalformedUri", new Object[0]));
        }
        String command = args[0];
        Map<String, String> attributes = this.parseUri(args[1]);
        if (!StringUtils.equalsIgnoreCase((String)"checkout", (String)command)) {
            throw new RuntimeException(TfPluginBundle.message("Starter.Errors.SubCommandNotRecognized", command));
        }
        SimpleCheckoutStarter starter = SimpleCheckoutStarter.createWithUriAttributes(attributes);
        starter.processCommand();
    }

    protected Map<String, String> parseUri(String uri) {
        List<String> args = Arrays.asList(uri.split("&"));
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String arg : args) {
            int index = arg.indexOf(61);
            if (index == -1) continue;
            String key = arg.substring(0, index);
            String value = arg.length() > index + 1 ? arg.substring(index + 1) : "";
            attributes.put(key, value);
        }
        attributes.remove(IDE_TYPE_ATTRIBUTE);
        attributes.remove(IDE_EXE_ATTRIBUTE);
        this.logger.debug("The URI attributes found are: " + attributes.entrySet().toString());
        return attributes;
    }
}

