/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.statusBar;

import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.Consumer;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.statusBar.BuildPopup;
import com.microsoft.alm.plugin.idea.common.statusBar.BuildStatusModel;
import com.microsoft.alm.plugin.telemetry.TfsTelemetryHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildWidget
implements StatusBarWidget,
StatusBarWidget.IconPresentation,
Consumer<MouseEvent> {
    private BuildStatusModel model;
    private StatusBar statusBar;

    public static String getID() {
        return BuildWidget.class.getName();
    }

    public void update(BuildStatusModel model) {
        this.model = model;
    }

    @NotNull
    public String ID() {
        return BuildWidget.getID();
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        return this;
    }

    public void install(@NotNull StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public void dispose() {
        this.statusBar = null;
    }

    @NotNull
    public Icon getIcon() {
        if (this.model == null || !this.model.hasStatusInformation()) {
            return Icons.BUILD_STATUS_UNKNOWN;
        }
        if (this.model.isSuccessful()) {
            return Icons.BUILD_STATUS_SUCCEEDED;
        }
        return Icons.BUILD_STATUS_FAILED;
    }

    @Nullable
    public String getTooltipText() {
        return this.model != null ? this.model.getDescription() : "";
    }

    @Nullable
    public Consumer<MouseEvent> getClickConsumer() {
        return this;
    }

    public void consume(MouseEvent mouseEvent) {
        if (this.model != null) {
            String eventName = String.format("VSO/Plugin/Action/%s", "BuildStatusBarClick");
            TfsTelemetryHelper.sendEventAsync((String)eventName, (Map)new TfsTelemetryHelper.PropertyMapBuilder().activeServerContext().build());
            BuildPopup popup = new BuildPopup(this.model);
            Component c = mouseEvent.getComponent();
            if (c != null) {
                Dimension d = popup.getPreferredSize();
                popup.show(c, c.getWidth() - d.width, 0 - d.height);
            }
        }
    }
}

