/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.authentication;

import com.intellij.ide.BrowserUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.microsoft.alm.auth.oauth.DeviceFlowResponse;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.BasicForm;
import com.microsoft.alm.plugin.idea.common.ui.controls.Hyperlink;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DeviceFlowResponsePromptForm
implements BasicForm {
    private JPanel contentPanel;
    private JTextField userCodeTextField;
    private Hyperlink verificationUriLink;
    private DeviceFlowResponse response;
    private boolean initialized = false;

    public DeviceFlowResponsePromptForm() {
        this.$$$setupUI$$$();
    }

    @Override
    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.contentPanel;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.verificationUriLink;
    }

    @Override
    public void addActionListener(ActionListener listener) {
    }

    public void setResponse(DeviceFlowResponse response) {
        this.response = response;
        this.verificationUriLink.setText(this.response.getVerificationUri().toString());
        this.userCodeTextField.setText(response.getUserCode());
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.verificationUriLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DeviceFlowResponsePromptForm.this.response != null) {
                        BrowserUtil.browse((URI)DeviceFlowResponsePromptForm.this.response.getVerificationUri());
                    }
                }
            });
            this.initialized = true;
        }
    }

    private void $$$setupUI$$$() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Authentication.DeviceFlowVisitUrl"));
        this.contentPanel.add((Component)label1, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.contentPanel.add((Component)spacer1, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.contentPanel.add((Component)spacer2, new GridConstraints(1, 0, 2, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.verificationUriLink = new Hyperlink();
        this.contentPanel.add((Component)((Object)this.verificationUriLink), new GridConstraints(1, 1, 1, 1, 1, 0, 3, 3, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        this.$$$loadLabelText$$$(label2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Authentication.DeviceFlowEnterFollowingCode"));
        this.contentPanel.add((Component)label2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.userCodeTextField = new JTextField();
        this.contentPanel.add((Component)this.userCodeTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label3 = new JLabel();
        this.$$$loadLabelText$$$(label3, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Authentication.DeviceFlowContinueAfterLogin"));
        this.contentPanel.add((Component)label3, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }
}

