/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.checkout;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutForm;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutModel;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutPage;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutPageController;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutPageImpl;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutPageModel;
import com.microsoft.alm.plugin.idea.common.ui.checkout.VcsSpecificCheckoutModel;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialog;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialogImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.ValidationListener;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.LoginForm;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.TfsLoginForm;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.VsoLoginForm;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;

public class CheckoutController
implements Observer {
    private final BaseDialog dialog;
    private final CheckoutModel model;
    private final CheckoutPageController vsoController;
    private final CheckoutPageController tfsController;
    public static final int TAB_VSO = 0;
    public static final int TAB_TFS = 1;

    public CheckoutController(Project project, CheckoutProvider.Listener listener, VcsSpecificCheckoutModel specificCheckoutModel) {
        this(new BaseDialogImpl(project, TfPluginBundle.message("CheckoutDialog.Title", new Object[0]), specificCheckoutModel.getButtonText(), "CheckoutDialog.Title"), new CheckoutPageImpl((LoginForm)new VsoLoginForm(), new CheckoutForm(true, specificCheckoutModel.getRepositoryType())), new CheckoutPageImpl((LoginForm)new TfsLoginForm(), new CheckoutForm(false, specificCheckoutModel.getRepositoryType())), new CheckoutModel(project, listener, specificCheckoutModel));
    }

    public CheckoutController(BaseDialog dialog, CheckoutPage vsoCheckoutPage, CheckoutPage tfsCheckoutPage, CheckoutModel checkoutModel) {
        this.model = checkoutModel;
        this.dialog = dialog;
        this.vsoController = new CheckoutPageController(this, this.model.getVsoModel(), vsoCheckoutPage);
        this.tfsController = new CheckoutPageController(this, this.model.getTfsModel(), tfsCheckoutPage);
        this.setupDialog();
        this.model.addObserver(this);
    }

    public CheckoutModel getModel() {
        return this.model;
    }

    public void gotoEnterVsoURL() {
        this.model.getTfsModel().signOut();
        this.model.setVsoSelected(false);
    }

    public boolean showModalDialog() {
        return this.dialog.showModalDialog();
    }

    @Override
    public void update(Observable o, Object arg) {
        if ("cloneEnabled".equals(arg)) {
            this.dialog.setOkEnabled(this.model.isCloneEnabled());
        } else if ("vsoSelected".equals(arg)) {
            this.dialog.setSelectedTabIndex(this.model.isVsoSelected() ? 0 : 1);
            this.dialog.setOkEnabled(this.model.isCloneEnabled());
        } else if ("errors".equals(arg)) {
            if (this.model.hasErrors()) {
                this.dialog.displayError(this.model.getErrors().get(0).getValidationMessage());
            } else {
                this.dialog.displayError(null);
            }
        }
    }

    public void gotoTab(int tabId) {
        this.model.setVsoSelected(tabId == 0);
    }

    private void setupDialog() {
        this.dialog.addTabPage(TfPluginBundle.message("CheckoutDialog.VsoTab", new Object[0]), this.vsoController.getPageAsPanel());
        this.dialog.addTabPage(TfPluginBundle.message("CheckoutDialog.TfsTab", new Object[0]), this.tfsController.getPageAsPanel());
        this.dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("ok".equals(e.getActionCommand())) {
                    CheckoutController.this.cloneRepo();
                } else if ("cancel".equals(e.getActionCommand())) {
                    CheckoutController.this.model.dispose();
                } else if ("tabChanged".equals(e.getActionCommand())) {
                    CheckoutController.this.model.clearErrors();
                    CheckoutController.this.model.setVsoSelected(CheckoutController.this.dialog.getSelectedTabIndex() == 0);
                }
            }
        });
        this.dialog.addValidationListener(new ValidationListener(){

            @Override
            public ValidationInfo doValidate() {
                return CheckoutController.this.validate();
            }
        });
        if (ServerContextManager.getInstance().lastUsedContextIsTFS()) {
            this.dialog.setSelectedTabIndex(1);
        }
        this.dialog.setOkEnabled(this.model.isCloneEnabled());
    }

    private void cloneRepo() {
        CheckoutPageModel pageModel = this.getActivePageModel();
        pageModel.cloneSelectedRepo();
    }

    private ValidationInfo validate() {
        ValidationInfo result;
        CheckoutPageModel pageModel = this.getActivePageModel();
        ModelValidationInfo error = this.model.hasErrors() ? this.model.getErrors().get(0) : pageModel.validate();
        if (error != null) {
            JComponent errorSource = this.model.isVsoSelected() ? this.vsoController.getComponent(error.getValidationSource()) : this.tfsController.getComponent(error.getValidationSource());
            result = new ValidationInfo(error.getValidationMessage(), errorSource);
        } else {
            result = null;
        }
        return result;
    }

    private CheckoutPageModel getActivePageModel() {
        CheckoutPageModel pageModel;
        if (this.model.isVsoSelected()) {
            this.vsoController.updateModel();
            pageModel = this.model.getVsoModel();
        } else {
            this.tfsController.updateModel();
            pageModel = this.model.getTfsModel();
        }
        return pageModel;
    }
}

