/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.checkout;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.TableFocusListener;
import com.microsoft.alm.plugin.idea.common.ui.common.TableModelSelectionConverter;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.BasicForm;
import com.microsoft.alm.plugin.idea.common.ui.controls.BusySpinnerPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.HelpPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.HintTextFieldUI;
import com.microsoft.alm.plugin.idea.common.ui.controls.UserAccountPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableRowSorter;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NonNls;

public class CheckoutForm
implements BasicForm {
    private JTextField repositoryFilter;
    private JTable repositoryTable;
    private JTextField directoryName;
    private JPanel contentPanel;
    private UserAccountPanel userAccountPanel;
    private TextFieldWithBrowseButton parentDirectory;
    private JButton refreshButton;
    private BusySpinnerPanel busySpinner;
    private JScrollPane repositoryTableScrollPane;
    private HelpPanel helpPanel;
    private JCheckBox advancedCheckBox;
    private boolean initialized = false;
    private RepositoryContext.Type repositoryType;
    private Timer timer;
    @NonNls
    public static final String CMD_REPO_FILTER_CHANGED = "repositoryFilterChanged";
    @NonNls
    public static final String CMD_REFRESH = "refresh";
    @NonNls
    public static final String CMD_GOTO_TFS = "gotoTFS";
    @NonNls
    public static final String CMD_GOTO_SPS_PROFILE = "gotoSPSProfile";

    public CheckoutForm(boolean vsoSelected, RepositoryContext.Type repositoryType) {
        this.repositoryType = repositoryType;
        this.$$$setupUI$$$();
        this.userAccountPanel.setWindowsAccount(!vsoSelected);
    }

    @Override
    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.contentPanel;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.repositoryFilter.setActionCommand(CMD_REPO_FILTER_CHANGED);
            this.refreshButton.setActionCommand(CMD_REFRESH);
            SwingHelper.scaleTableRowHeight(this.repositoryTable);
            SwingHelper.fixTabKeys(this.repositoryTable);
            this.repositoryTable.addFocusListener(new TableFocusListener(this.repositoryTable));
            this.helpPanel.addPopupCommand(TfPluginBundle.message("VsoLookupHelp.EnterUrl", new Object[0]), CMD_GOTO_TFS);
            this.helpPanel.addPopupCommand(TfPluginBundle.message("VsoLookupHelp.ViewAccounts", new Object[0]), CMD_GOTO_SPS_PROFILE);
            this.helpPanel.setVisible(false);
            this.repositoryFilter.setUI(new HintTextFieldUI(TfPluginBundle.message("CheckoutDialog.FilterHint", new Object[0])));
            this.parentDirectory.getInsets().right = 0;
            this.parentDirectory.addBrowseFolderListener(TfPluginBundle.message("CheckoutDialog.ParentFolder.DialogTitle", new Object[0]), null, null, new FileChooserDescriptor(false, true, false, false, false, false));
            int refreshButtonHeight = (int)this.refreshButton.getMinimumSize().getHeight();
            Dimension size = new Dimension(refreshButtonHeight, refreshButtonHeight);
            this.refreshButton.setMinimumSize(size);
            this.refreshButton.setPreferredSize(size);
            this.busySpinner.setMinimumSize(size);
            this.busySpinner.setPreferredSize(size);
            this.repositoryFilter.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                private void onFilterChanged() {
                    if (CheckoutForm.this.timer.isRunning()) {
                        CheckoutForm.this.timer.restart();
                    } else {
                        CheckoutForm.this.timer.start();
                    }
                }
            });
            this.repositoryTableScrollPane.setMinimumSize(new Dimension(JBUI.scale((int)200), JBUI.scale((int)70)));
            this.advancedCheckBox.setSelected(false);
            if (this.repositoryType == RepositoryContext.Type.TFVC) {
                this.advancedCheckBox.setVisible(true);
                this.advancedCheckBox.setText(TfPluginBundle.message("CheckoutDialog.Tfvc.Advanced", new Object[0]));
            } else {
                this.advancedCheckBox.setVisible(false);
            }
            this.initialized = true;
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.userAccountPanel.addActionListener(listener);
        this.timer.addActionListener(listener);
        this.refreshButton.addActionListener(listener);
        this.helpPanel.addActionListener(listener);
    }

    public void setRepositoryFilter(String filter) {
        this.repositoryFilter.setText(filter);
    }

    public String getRepositoryFilter() {
        return this.repositoryFilter.getText();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.repositoryFilter;
    }

    public void setRepositoryTable(ServerContextTableModel tableModel, ListSelectionModel selectionModel) {
        this.repositoryTable.setModel(tableModel);
        this.repositoryTable.setSelectionModel(selectionModel);
        TableRowSorter<ServerContextTableModel> sorter = new TableRowSorter<ServerContextTableModel>(tableModel);
        this.repositoryTable.setRowSorter(sorter);
        tableModel.setSelectionConverter(new TableModelSelectionConverter(){

            @Override
            public int convertRowIndexToModel(int viewRowIndex) {
                if (viewRowIndex >= 0) {
                    return CheckoutForm.this.repositoryTable.convertRowIndexToModel(viewRowIndex);
                }
                return viewRowIndex;
            }
        });
    }

    public void setParentDirectory(String path) {
        this.parentDirectory.setText(path);
    }

    public String getParentDirectory() {
        return StringUtils.trim((String)this.parentDirectory.getText());
    }

    public JComponent getParentDirectoryComponent() {
        return this.parentDirectory.getTextField();
    }

    public void setDirectoryName(String name) {
        this.directoryName.setText(name);
    }

    public String getDirectoryName() {
        return StringUtils.trim((String)this.directoryName.getText());
    }

    public JComponent getDirectoryNameComponent() {
        return this.directoryName;
    }

    public void setUserName(String name) {
        this.userAccountPanel.setUserName(name);
    }

    public void setServerName(String name) {
        this.userAccountPanel.setServerName(name);
        if (!this.userAccountPanel.isWindowsAccount() || UrlHelper.isTeamServicesUrl((String)name)) {
            this.helpPanel.setVisible(true);
        } else {
            this.helpPanel.setVisible(false);
        }
    }

    public void setLoading(boolean loading) {
        if (loading) {
            this.refreshButton.setVisible(false);
            this.busySpinner.start(true);
        } else {
            this.busySpinner.stop(true);
            this.refreshButton.setVisible(true);
        }
    }

    public boolean isAdvanced() {
        return this.advancedCheckBox.isSelected();
    }

    public void setAdvanced(boolean advanced) {
        this.advancedCheckBox.setSelected(advanced);
    }

    private void createUIComponents() {
        this.userAccountPanel = new UserAccountPanel();
        this.refreshButton = new JButton(AllIcons.Actions.Refresh);
        this.timer = new Timer(400, null);
        this.timer.setInitialDelay(400);
        this.timer.setActionCommand(CMD_REPO_FILTER_CHANGED);
        this.timer.setRepeats(false);
    }

    @VisibleForTesting
    UserAccountPanel getUserAccountPanel() {
        return this.userAccountPanel;
    }

    @VisibleForTesting
    BusySpinnerPanel getBusySpinner() {
        return this.busySpinner;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout((LayoutManager)new GridLayoutManager(10, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPanel.setName("");
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoCheckoutForm.SelectRepository"));
        this.contentPanel.add((Component)label1, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        this.repositoryFilter = new JTextField();
        this.repositoryFilter.setName("");
        this.contentPanel.add((Component)this.repositoryFilter, new GridConstraints(2, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label2 = new JLabel();
        this.$$$loadLabelText$$$(label2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoCheckoutForm.ParentDirectory"));
        this.contentPanel.add((Component)label2, new GridConstraints(5, 0, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label3 = new JLabel();
        this.$$$loadLabelText$$$(label3, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoCheckoutForm.DirectoryName"));
        this.contentPanel.add((Component)label3, new GridConstraints(7, 0, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        this.directoryName = new JTextField();
        this.directoryName.setName("");
        this.contentPanel.add((Component)this.directoryName, new GridConstraints(8, 0, 1, 3, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.contentPanel.add((Component)this.userAccountPanel, new GridConstraints(0, 0, 1, 3, 4, 0, 3, 3, null, null, null, 0, false));
        this.repositoryTableScrollPane = new JScrollPane();
        this.contentPanel.add((Component)this.repositoryTableScrollPane, new GridConstraints(3, 0, 1, 3, 0, 3, 5, 5, null, null, null, 0, false));
        this.repositoryTable = new JTable();
        this.repositoryTable.setFillsViewportHeight(true);
        this.repositoryTable.setName("");
        this.repositoryTable.setShowHorizontalLines(false);
        this.repositoryTable.setShowVerticalLines(false);
        this.repositoryTableScrollPane.setViewportView(this.repositoryTable);
        this.parentDirectory = new TextFieldWithBrowseButton();
        this.contentPanel.add((Component)this.parentDirectory, new GridConstraints(6, 0, 1, 3, 0, 1, 3, 3, null, null, null, 0, false));
        this.helpPanel = new HelpPanel();
        this.helpPanel.setHelpText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoLookupHelp.helpText"));
        this.helpPanel.setPopupText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoLookupHelp.Instructions"));
        this.contentPanel.add((Component)this.helpPanel, new GridConstraints(4, 0, 1, 3, 4, 0, 3, 3, null, null, null, 0, false));
        this.advancedCheckBox = new JCheckBox();
        this.advancedCheckBox.setText("example text");
        this.contentPanel.add((Component)this.advancedCheckBox, new GridConstraints(9, 0, 1, 3, 8, 0, 3, 0, null, null, null, 0, false));
        this.busySpinner = new BusySpinnerPanel();
        this.contentPanel.add((Component)this.busySpinner, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.refreshButton.setToolTipText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CheckoutDialog.RefreshButton.ToolTip"));
        this.contentPanel.add((Component)this.refreshButton, new GridConstraints(2, 2, 1, 1, 0, 1, 1, 0, null, null, null, 0, false));
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }
}

