/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.checkout;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutPageModel;
import com.microsoft.alm.plugin.idea.common.ui.checkout.TfsCheckoutPageModel;
import com.microsoft.alm.plugin.idea.common.ui.checkout.VcsSpecificCheckoutModel;
import com.microsoft.alm.plugin.idea.common.ui.checkout.VsoCheckoutPageModel;
import com.microsoft.alm.plugin.idea.common.ui.common.PageModelImpl;

public class CheckoutModel
extends PageModelImpl
implements VcsSpecificCheckoutModel {
    private boolean vsoSelected = true;
    private boolean cloneEnabledForVso = false;
    private boolean cloneEnabledForTfs = false;
    private final CheckoutPageModel vsoModel;
    private final CheckoutPageModel tfsModel;
    private final Project project;
    private final CheckoutProvider.Listener listener;
    private final VcsSpecificCheckoutModel specificCheckoutModel;
    public static final String PROP_VSO_SELECTED = "vsoSelected";
    public static final String PROP_CLONE_ENABLED = "cloneEnabled";

    public CheckoutModel(Project project, CheckoutProvider.Listener listener, VcsSpecificCheckoutModel specificCheckoutModel) {
        this(project, listener, specificCheckoutModel, null, null, true);
    }

    @VisibleForTesting
    public CheckoutModel(Project project, CheckoutProvider.Listener listener, VcsSpecificCheckoutModel specificCheckoutModel, CheckoutPageModel vsoModel, CheckoutPageModel tfsModel, boolean autoLoad) {
        this.project = project;
        this.listener = listener;
        this.specificCheckoutModel = specificCheckoutModel;
        this.vsoModel = vsoModel == null ? new VsoCheckoutPageModel(this, autoLoad) : vsoModel;
        this.tfsModel = tfsModel == null ? new TfsCheckoutPageModel(this) : tfsModel;
        this.updateCloneEnabled();
    }

    public boolean isVsoSelected() {
        return this.vsoSelected;
    }

    public void setVsoSelected(boolean value) {
        if (this.vsoSelected != value) {
            this.vsoSelected = value;
            super.setChangedAndNotify(PROP_VSO_SELECTED);
        }
    }

    public boolean isCloneEnabled() {
        if (this.isVsoSelected()) {
            return this.cloneEnabledForVso;
        }
        return this.cloneEnabledForTfs;
    }

    public void updateCloneEnabled() {
        if (this.vsoModel != null) {
            this.setCloneEnabledForVso(this.vsoModel.isConnected());
        }
        if (this.tfsModel != null) {
            this.setCloneEnabledForTfs(this.tfsModel.isConnected());
        }
    }

    protected void setCloneEnabledForTfs(boolean value) {
        if (this.cloneEnabledForTfs != value) {
            this.cloneEnabledForTfs = value;
            super.setChangedAndNotify(PROP_CLONE_ENABLED);
        }
    }

    protected void setCloneEnabledForVso(boolean value) {
        if (this.cloneEnabledForVso != value) {
            this.cloneEnabledForVso = value;
            super.setChangedAndNotify(PROP_CLONE_ENABLED);
        }
    }

    public CheckoutPageModel getVsoModel() {
        return this.vsoModel;
    }

    public CheckoutPageModel getTfsModel() {
        return this.tfsModel;
    }

    public Project getProject() {
        return this.project;
    }

    public CheckoutProvider.Listener getListener() {
        return this.listener;
    }

    public void dispose() {
        this.vsoModel.dispose();
        this.tfsModel.dispose();
    }

    @Override
    public void doCheckout(Project project, CheckoutProvider.Listener listener, ServerContext context, VirtualFile destinationParent, String directoryName, String parentDirectory, boolean isAdvancedChecked) {
        this.specificCheckoutModel.doCheckout(project, listener, context, destinationParent, directoryName, parentDirectory, isAdvancedChecked);
    }

    @Override
    public String getTelemetryAction() {
        return this.specificCheckoutModel.getTelemetryAction();
    }

    @Override
    public String getButtonText() {
        return this.specificCheckoutModel.getButtonText();
    }

    @Override
    public String getRepositoryName(ServerContext context) {
        return this.specificCheckoutModel.getRepositoryName(context);
    }

    @Override
    public RepositoryContext.Type getRepositoryType() {
        return this.specificCheckoutModel.getRepositoryType();
    }
}

