/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.checkout;

import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutController;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutPage;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutPageModel;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractController;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JPanel;

class CheckoutPageController
extends AbstractController {
    private final CheckoutPage page;
    private final CheckoutPageModel model;
    private final CheckoutController parentController;

    public CheckoutPageController(CheckoutController parentController, CheckoutPageModel model, CheckoutPage page) {
        this.parentController = parentController;
        this.model = model;
        this.model.addObserver(this);
        this.page = page;
        this.page.addActionListener(this);
        this.update(null, null);
    }

    public JPanel getPageAsPanel() {
        if (this.page instanceof JPanel) {
            return (JPanel)((Object)this.page);
        }
        return null;
    }

    public JComponent getComponent(String name) {
        return this.page.getComponent(name);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null || arg.equals("connected")) {
            this.page.setLoginShowing(!this.model.isConnected());
        }
        if (arg == null || arg.equals("loading")) {
            this.page.setLoading(this.model.isLoading());
        }
        if (arg == null || arg.equals("advanced")) {
            this.page.setAdvanced(this.model.isAdvanced());
        }
        if (arg == null || arg.equals("authenticating")) {
            this.page.setAuthenticating(this.model.isAuthenticating());
        }
        if (arg == null || arg.equals("directoryName")) {
            this.page.setDirectoryName(this.model.getDirectoryName());
        }
        if (arg == null || arg.equals("parentDirectory")) {
            this.page.setParentDirectory(this.model.getParentDirectory());
        }
        if (arg == null || arg.equals("repositoryFilter")) {
            this.page.setRepositoryFilter(this.model.getRepositoryFilter());
        }
        if (arg == null || arg.equals("userName")) {
            this.page.setUserName(this.model.getUserName());
        }
        if (arg == null || arg.equals("serverName")) {
            this.page.setServerName(this.model.getServerName());
        }
        if (arg == null) {
            this.page.setRepositoryTable(this.model.getTableModel(), this.model.getTableSelectionModel());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
        this.model.clearErrors();
        if ("signIn".equals(e.getActionCommand())) {
            this.model.loadRepositories();
            super.requestFocus(this.page);
        } else if ("refresh".equals(e.getActionCommand())) {
            this.model.loadRepositories();
        } else if ("signOut".equals(e.getActionCommand())) {
            this.model.setConnected(false);
            this.model.signOut();
            super.requestFocus(this.page);
        } else if (!"repositoryFilterChanged".equals(e.getActionCommand())) {
            if ("createAccount".equals(e.getActionCommand())) {
                this.model.gotoLink("https://go.microsoft.com/fwlink/?LinkId=307137&wt.mc_id=o~msft~java~intellij");
            } else if ("learnMore".equals(e.getActionCommand())) {
                this.model.gotoLink("http://java.visualstudio.com");
            } else if ("gotoTFS".equals(e.getActionCommand())) {
                this.parentController.gotoEnterVsoURL();
            } else if ("gotoSPSProfile".equals(e.getActionCommand())) {
                this.model.gotoLink("https://app.vssps.visualstudio.com");
            }
        }
    }

    @Override
    protected void updateModel() {
        this.model.setParentDirectory(this.page.getParentDirectory());
        this.model.setDirectoryName(this.page.getDirectoryName());
        this.model.setRepositoryFilter(this.page.getRepositoryFilter());
        this.model.setServerName(this.page.getServerName());
        this.model.setAdvanced(this.page.getAdvanced());
    }
}

