/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.checkout;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutModel;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutPageModel;
import com.microsoft.alm.plugin.idea.common.ui.common.LoginPageModelImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextLookupListener;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextLookupPageModel;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import com.microsoft.alm.plugin.telemetry.TfsTelemetryHelper;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;

public abstract class CheckoutPageModelImpl
extends LoginPageModelImpl
implements CheckoutPageModel,
ServerContextLookupPageModel {
    private CheckoutModel parentModel;
    private boolean loading = false;
    private boolean cloneEnabled = false;
    private boolean advanced = false;
    private String parentDirectory = "";
    private String directoryName = "";
    private String repositoryFilter = "";
    private final ServerContextTableModel repositoryTableModel;
    private final ServerContextLookupListener repositoryProvider;

    public CheckoutPageModelImpl(CheckoutModel checkoutModel, ServerContextTableModel.Column[] columns) {
        super(checkoutModel);
        this.parentModel = checkoutModel;
        this.repositoryTableModel = new ServerContextTableModel(columns);
        this.setupSelectionListener();
        this.parentDirectory = PluginServiceProvider.getInstance().getPropertyService().getProperty("repoRoot");
        if (StringUtils.isEmpty((String)this.parentDirectory)) {
            this.parentDirectory = DEFAULT_SOURCE_PATH;
        }
        this.repositoryProvider = new ServerContextLookupListener(this);
    }

    protected CheckoutModel getParentModel() {
        return this.parentModel;
    }

    protected void setParentModel(CheckoutModel parentModel) {
        this.parentModel = parentModel;
    }

    protected ServerContextLookupListener getRepositoryProvider() {
        return this.repositoryProvider;
    }

    protected abstract AuthenticationInfo getAuthenticationInfo();

    @Override
    public void signOut() {
        super.signOut();
        this.setConnected(false);
        this.setLoading(false);
        this.clearContexts();
    }

    @Override
    public String getParentDirectory() {
        return this.parentDirectory;
    }

    @Override
    public void setParentDirectory(String parentDirectory) {
        if (!StringUtils.equals((String)this.parentDirectory, (String)parentDirectory)) {
            this.parentDirectory = parentDirectory;
            this.setChangedAndNotify("parentDirectory");
        }
    }

    @Override
    public String getDirectoryName() {
        return this.directoryName;
    }

    @Override
    public void setDirectoryName(String directoryName) {
        if (!StringUtils.equals((String)this.directoryName, (String)directoryName)) {
            this.directoryName = directoryName;
            this.setChangedAndNotify("directoryName");
        }
    }

    @Override
    public String getRepositoryFilter() {
        return this.repositoryFilter;
    }

    @Override
    public void setRepositoryFilter(String repositoryFilter) {
        if (!StringUtils.equals((String)this.repositoryFilter, (String)repositoryFilter)) {
            this.repositoryFilter = repositoryFilter;
            this.setChangedAndNotify("repositoryFilter");
            this.repositoryTableModel.setFilter(repositoryFilter);
        }
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public void setAdvanced(boolean advanced) {
        if (this.advanced != advanced) {
            this.advanced = advanced;
            this.setChangedAndNotify("advanced");
        }
    }

    @Override
    public boolean isAdvanced() {
        return this.advanced;
    }

    @Override
    public void setLoading(boolean loading) {
        if (this.loading != loading) {
            this.loading = loading;
            this.setChangedAndNotify("loading");
        }
    }

    @Override
    public void setCloneEnabled(boolean cloneEnabled) {
        if (this.cloneEnabled != cloneEnabled) {
            this.cloneEnabled = cloneEnabled;
            if (this.getParentModel() != null) {
                this.getParentModel().updateCloneEnabled();
            }
        }
    }

    @Override
    public void setConnected(boolean connected) {
        super.setConnected(connected);
        this.setCloneEnabled(connected);
    }

    @Override
    public ServerContextTableModel getTableModel() {
        return this.repositoryTableModel;
    }

    @Override
    public ListSelectionModel getTableSelectionModel() {
        return this.repositoryTableModel.getSelectionModel();
    }

    @Override
    public ModelValidationInfo validate() {
        ModelValidationInfo result = super.validate();
        if (result == ModelValidationInfo.NO_ERRORS) {
            VirtualFile destinationParent;
            String parentDirectory = this.getParentDirectory();
            if (parentDirectory == null || parentDirectory.isEmpty()) {
                return ModelValidationInfo.createWithResource("parentDirectory", "CheckoutDialog.Errors.ParentDirEmpty", new Object[0]);
            }
            File parentDirectoryOnDisk = new File(parentDirectory);
            if (!parentDirectoryOnDisk.exists()) {
                return ModelValidationInfo.createWithResource("parentDirectory", "CheckoutDialog.Errors.ParentDirNotFound", new Object[0]);
            }
            if (ApplicationManager.getApplication() != null && (destinationParent = LocalFileSystem.getInstance().findFileByPath(parentDirectory)) == null) {
                return ModelValidationInfo.createWithResource("parentDirectory", "CheckoutDialog.Errors.ParentDirNotFound", new Object[0]);
            }
            if (this.getSelectedContext() == null) {
                return ModelValidationInfo.createWithResource("repoTable", "CheckoutDialog.Errors.RepoNotSelected", new Object[0]);
            }
            String directoryName = this.getDirectoryName();
            if (directoryName == null || directoryName.isEmpty()) {
                return ModelValidationInfo.createWithResource("directoryName", "CheckoutDialog.Errors.DirNameEmpty", new Object[0]);
            }
            File destDirectoryOnDisk = new File(parentDirectory, directoryName);
            if (destDirectoryOnDisk.exists() && destDirectoryOnDisk.isDirectory()) {
                return ModelValidationInfo.createWithResource("directoryName", "CheckoutDialog.Errors.DestinationExists", directoryName);
            }
            if (destDirectoryOnDisk.getParentFile() == null || !destDirectoryOnDisk.getParentFile().exists()) {
                return ModelValidationInfo.createWithResource("directoryName", "CheckoutDialog.Errors.DirNameInvalid", directoryName, destDirectoryOnDisk.getParent());
            }
        } else {
            return result;
        }
        return ModelValidationInfo.NO_ERRORS;
    }

    @Override
    public abstract void loadRepositories();

    @Override
    public void cloneSelectedRepo() {
        ModelValidationInfo validationInfo = this.validate();
        if (validationInfo == null) {
            ServerContext context = this.getSelectedContext();
            super.completeSignIn(context);
            VirtualFile destinationParent = LocalFileSystem.getInstance().findFileByIoFile(new File(this.getParentDirectory()));
            this.parentModel.doCheckout(this.getParentModel().getProject(), this.getParentModel().getListener(), context, destinationParent, this.getDirectoryName(), this.getParentDirectory(), this.isAdvanced());
            PluginServiceProvider.getInstance().getPropertyService().setProperty("repoRoot", this.getParentDirectory());
            String action = this.parentModel.getTelemetryAction();
            TfsTelemetryHelper.sendEventAsync((String)action, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(context).actionName(action).success(Boolean.valueOf(true)).build());
        }
    }

    public ServerContext getSelectedContext() {
        return this.repositoryTableModel.getSelectedContext();
    }

    @Override
    public void clearContexts() {
        this.repositoryTableModel.clearRows();
    }

    @Override
    public void appendContexts(List<ServerContext> serverContexts) {
        this.repositoryTableModel.addServerContexts(serverContexts);
    }

    protected void addContext(ServerContext serverContext) {
        this.appendContexts(Collections.singletonList(serverContext));
    }

    private void setupSelectionListener() {
        this.repositoryTableModel.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ServerContext row = CheckoutPageModelImpl.this.repositoryTableModel.getSelectedContext();
                    String repositoryName = CheckoutPageModelImpl.this.parentModel.getRepositoryName(row);
                    CheckoutPageModelImpl.this.setDirectoryName(repositoryName);
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.repositoryProvider.terminateActiveOperation();
    }
}

