/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.checkout;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.AuthenticationProvider;
import com.microsoft.alm.plugin.authentication.VsoAuthenticationProvider;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutModel;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutPageModelImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.LookupHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import com.microsoft.alm.plugin.operations.ServerContextLookupOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VsoCheckoutPageModel
extends CheckoutPageModelImpl {
    private static final Logger logger = LoggerFactory.getLogger(VsoCheckoutPageModel.class);
    private VsoAuthenticationProvider authenticationProvider = VsoAuthenticationProvider.getInstance();
    private final ServerContextLookupOperation.ContextScope scope;

    public VsoCheckoutPageModel(CheckoutModel checkoutModel) {
        this(checkoutModel, true);
    }

    @VisibleForTesting
    public VsoCheckoutPageModel(CheckoutModel checkoutModel, boolean autoLoad) {
        super(checkoutModel, checkoutModel.getRepositoryType() == RepositoryContext.Type.GIT ? ServerContextTableModel.VSO_GIT_REPO_COLUMNS : ServerContextTableModel.VSO_TFVC_REPO_COLUMNS);
        this.setServerNameInternal(TfPluginBundle.message("UserAccountPanel.VSO.ServerName", new Object[0]));
        this.setConnected(false);
        this.setAuthenticating(false);
        this.scope = checkoutModel.getRepositoryType() == RepositoryContext.Type.GIT ? ServerContextLookupOperation.ContextScope.REPOSITORY : ServerContextLookupOperation.ContextScope.PROJECT;
        String serverUri = LookupHelper.getVsspsUrlFromDisplayName(this.getServerName());
        if (autoLoad && this.authenticationProvider.isAuthenticated(serverUri)) {
            logger.info("Loading contexts in constructor");
            LookupHelper.loadVsoContexts(this, this, (AuthenticationProvider)this.authenticationProvider, this.getRepositoryProvider(), this.scope);
        } else {
            logger.info("Skipping loading contexts in constructor");
        }
    }

    @Override
    protected AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationProvider.getAuthenticationInfo(this.getServerName());
    }

    @Override
    public void signOut() {
        logger.info("signOut called");
        String serverUri = LookupHelper.getVsspsUrlFromDisplayName(this.getServerName());
        this.authenticationProvider.clearAuthenticationDetails(serverUri);
        super.signOut();
    }

    @Override
    public void loadRepositories() {
        logger.info("loadRepositories called");
        LookupHelper.authenticateAndLoadVsoContexts(this, this, (AuthenticationProvider)this.authenticationProvider, this.getRepositoryProvider(), this.scope);
    }
}

