/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialogImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.FeedbackForm;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.JComponent;
import org.apache.commons.lang.StringUtils;

public class FeedbackDialog
extends BaseDialogImpl {
    public static final String PROP_SMILE = "smile";
    private FeedbackForm feedbackForm;

    public FeedbackDialog(Project project, boolean smile) {
        super(project, TfPluginBundle.message("Feedback.Dialog.Title", new Object[0]), smile ? TfPluginBundle.message("Feedback.Dialog.OkButtonText.Smile", new Object[0]) : TfPluginBundle.message("Feedback.Dialog.OkButtonText.Frown", new Object[0]), "Feedback.Dialog.Title", false, Collections.singletonMap(PROP_SMILE, smile));
    }

    public String getComment() {
        return this.feedbackForm.getComment();
    }

    public String getEmail() {
        return this.feedbackForm.getEmail();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.feedbackForm.addActionListener(listener);
    }

    @Override
    protected ValidationInfo doValidate() {
        String email = this.getEmail();
        if (!StringUtils.isEmpty((String)email) && !this.isValidEmail(email)) {
            return new ValidationInfo(TfPluginBundle.message("Feedback.Dialog.Errors.InvalidEmail", email), this.feedbackForm.getEmailComponent());
        }
        return super.doValidate();
    }

    private boolean isValidEmail(String email) {
        return !StringUtils.isEmpty((String)email) && email.indexOf(64) > 0 && email.indexOf(64) < email.length() - 1;
    }

    @Override
    protected JComponent createCenterPanel() {
        this.feedbackForm = new FeedbackForm();
        return this.feedbackForm.getContentPanel((Boolean)this.getProperty(PROP_SMILE));
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.feedbackForm.getPreferredFocusedComponent();
    }
}

