/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common;

import com.microsoft.alm.plugin.idea.common.ui.common.LoginPage;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.BasicForm;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.LoginForm;
import com.microsoft.alm.plugin.telemetry.TfsTelemetryHelper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LoginPageImpl
extends JPanel
implements LoginPage {
    private final String DATA_FORM = "dataForm";
    private final String LOGIN_FORM = "loginForm";
    private final BasicForm dataForm;
    private final LoginForm loginForm;
    private final CardLayout cardLayout = new CardLayout();
    private boolean loginShowing;

    public LoginPageImpl(LoginForm loginForm, BasicForm dataForm) {
        this.setLayout(this.cardLayout);
        this.dataForm = dataForm;
        this.loginForm = loginForm;
        this.setLoginShowing(true);
        TfsTelemetryHelper.sendDialogOpenedAsync((String)this.getClass().getName(), (Map)TfsTelemetryHelper.PropertyMapBuilder.EMPTY);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.loginForm.addActionListener(listener);
        this.dataForm.addActionListener(listener);
    }

    @Override
    public JComponent getComponent(String name) {
        if ("serverName".equals(name)) {
            return this.loginForm.getServerNameComponent();
        }
        return null;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        if (this.loginShowing) {
            return this.loginForm.getPreferredFocusedComponent();
        }
        return this.dataForm.getPreferredFocusedComponent();
    }

    @Override
    public String getServerName() {
        return this.loginForm.getServerName();
    }

    @Override
    public void setServerName(String name) {
        this.loginForm.setServerName(name);
    }

    @Override
    public void setLoginShowing(boolean showLogin) {
        if (this.getComponentCount() == 0) {
            this.add((Component)this.dataForm.getContentPanel(), "dataForm");
            this.addComponentShownListener(this.dataForm);
            this.add((Component)this.loginForm.getContentPanel(), "loginForm");
            this.addComponentShownListener(this.loginForm);
        }
        if (this.loginShowing != showLogin) {
            this.loginShowing = showLogin;
            if (showLogin) {
                this.cardLayout.show(this, "loginForm");
            } else {
                this.cardLayout.show(this, "dataForm");
            }
        }
    }

    @Override
    public void setAuthenticating(boolean authenticating) {
        this.loginForm.setAuthenticating(authenticating);
    }

    private void addComponentShownListener(final BasicForm form) {
        form.getContentPanel().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                JComponent c = form.getPreferredFocusedComponent();
                if (c != null) {
                    c.requestFocusInWindow();
                }
            }
        });
    }
}

