/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common;

import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.facades.VsoAuthInfoProvider;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextBuilder;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractModel;
import com.microsoft.alm.plugin.idea.common.ui.common.LoginPageModel;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.PageModel;
import com.microsoft.alm.secret.TokenPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class LoginPageModelImpl
extends AbstractModel
implements LoginPageModel {
    private boolean connected = false;
    private boolean authenticating = false;
    private String userName = "";
    private String serverName = "";
    private PageModel pageModel;

    public LoginPageModelImpl(PageModel pageModel) {
        this.pageModel = pageModel;
    }

    public ServerContext completeSignIn(ServerContext context) {
        ServerContext effectiveContext;
        if (context.getType() == ServerContext.Type.TFS) {
            return ServerContextManager.getInstance().validateServerConnection(context);
        }
        AuthenticationInfo authenticationInfo = context.getAuthenticationInfo();
        if (AuthenticationInfo.CredsType.AccessToken.equals((Object)authenticationInfo.getType())) {
            TokenPair tokenPair = new TokenPair(authenticationInfo.getPassword(), authenticationInfo.getRefreshToken());
            AuthenticationInfo patBackedAuthenticationInfo = VsoAuthInfoProvider.getProvider().getAuthenticationInfo(context.getServerUri(), tokenPair);
            effectiveContext = new ServerContextBuilder(context).authentication(patBackedAuthenticationInfo).build();
        } else {
            effectiveContext = context;
        }
        ServerContextManager.getInstance().add(effectiveContext);
        return effectiveContext;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void setConnected(boolean connected) {
        if (this.connected != connected) {
            this.connected = connected;
            this.setChangedAndNotify("connected");
        }
    }

    @Override
    public void signOut() {
        this.setAuthenticating(false);
        this.setConnected(false);
        this.setServerName("");
        ServerContextManager.getInstance().clearLastUsedContext();
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        if (!StringUtils.equals((String)this.userName, (String)userName)) {
            this.userName = userName;
            this.setChangedAndNotify("userName");
        }
    }

    @Override
    public boolean isAuthenticating() {
        return this.authenticating;
    }

    @Override
    public void setAuthenticating(boolean authenticating) {
        if (this.authenticating != authenticating) {
            this.authenticating = authenticating;
            this.setChangedAndNotify("authenticating");
        }
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setServerName(String serverName) {
        if (!StringUtils.equals((String)this.serverName, (String)serverName)) {
            String newServerName = StringUtils.isNotEmpty((String)serverName) && !StringUtils.contains((String)serverName, (String)"/") && !StringUtils.equals((String)serverName, (String)TfPluginBundle.message("UserAccountPanel.VSO.ServerName", new Object[0])) && !StringUtils.containsIgnoreCase((String)serverName, (String)"visualstudio.com") && !StringUtils.containsIgnoreCase((String)serverName, (String)"tfsallin.net") ? String.format("http://%s:8080/tfs", serverName) : (!StringUtils.contains((String)serverName, (String)"/") && (StringUtils.containsIgnoreCase((String)serverName, (String)"visualstudio.com") || StringUtils.containsIgnoreCase((String)serverName, (String)"tfsallin.net")) ? String.format("https://%s", serverName) : serverName);
            this.setServerNameInternal(newServerName);
        }
    }

    protected void setServerNameInternal(String serverName) {
        this.serverName = UrlHelper.trimTrailingSeparators((String)serverName);
        this.setChangedAndNotify("serverName");
    }

    @Override
    public void addError(ModelValidationInfo error) {
        if (this.pageModel != null) {
            this.pageModel.addError(error);
        }
    }

    @Override
    public void clearErrors() {
        if (this.pageModel != null) {
            this.pageModel.clearErrors();
        }
    }

    @Override
    public List<ModelValidationInfo> getErrors() {
        if (this.pageModel != null) {
            return this.pageModel.getErrors();
        }
        return Collections.unmodifiableList(new ArrayList());
    }

    @Override
    public boolean hasErrors() {
        if (this.pageModel != null) {
            return this.pageModel.hasErrors();
        }
        return false;
    }

    @Override
    public ModelValidationInfo validate() {
        if (!this.isConnected()) {
            return ModelValidationInfo.createWithResource("connected", "LoginForm.Errors.NotConnected", new Object[0]);
        }
        return this.pageModel.validate();
    }
}

