/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common.forms;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.LoginForm;
import com.microsoft.alm.plugin.idea.common.ui.controls.BusySpinnerPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.Hyperlink;
import com.microsoft.alm.plugin.idea.common.ui.controls.IconPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.WrappingLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.commons.lang.StringUtils;

public class TfsLoginForm
implements LoginForm {
    private JTextField serverUrl;
    private Hyperlink signInLink;
    private IconPanel vsIcon;
    private JPanel contentPanel;
    private JLabel exampleLabel;
    private WrappingLabel descriptionLabel;
    private JLabel headerLabel;
    private BusySpinnerPanel busySpinner;
    private JLabel loginProgressLabel;
    private boolean initialized = false;

    public TfsLoginForm() {
        this.$$$setupUI$$$();
    }

    @Override
    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.contentPanel;
    }

    @Override
    public String getServerName() {
        return StringUtils.trim((String)this.serverUrl.getText());
    }

    @Override
    public void setServerName(String serverName) {
        this.serverUrl.setText(serverName);
    }

    @Override
    public JComponent getServerNameComponent() {
        return this.serverUrl;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.signInLink.addActionListener(listener);
        this.serverUrl.registerKeyboardAction(listener, "signIn", KeyStroke.getKeyStroke(10, 0), 2);
    }

    @Override
    public void setAuthenticating(boolean inProgress) {
        if (inProgress) {
            this.busySpinner.start(true);
            this.loginProgressLabel.setText(TfPluginBundle.message("LoginForm.TFS.Authenticating", new Object[0]));
            this.signInLink.setEnabled(false);
        } else {
            this.busySpinner.stop(true);
            this.loginProgressLabel.setText("");
            this.signInLink.setEnabled(true);
        }
    }

    private void createUIComponents() {
        this.vsIcon = new IconPanel(Icons.VSLogo);
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.signInLink.setActionCommand("signIn");
            this.headerLabel.setFont((Font)JBUI.Fonts.label((float)20.0f));
            this.signInLink.setFont((Font)JBUI.Fonts.label((float)16.0f));
            this.exampleLabel.setFont((Font)JBUI.Fonts.label((float)9.0f));
            Dimension size = new Dimension(JBUI.scale((int)20), JBUI.scale((int)20));
            this.busySpinner.setPreferredSize(size);
            this.busySpinner.setMinimumSize(size);
            this.descriptionLabel.setMargin(new Insets(0, 0, JBUI.scale((int)15), 0));
            this.initialized = true;
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.serverUrl;
    }

    @VisibleForTesting
    BusySpinnerPanel getBusySpinner() {
        return this.busySpinner;
    }

    @VisibleForTesting
    void setServerUrl(String serverUrl) {
        this.serverUrl.setText(serverUrl);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout((LayoutManager)new GridLayoutManager(7, 5, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.contentPanel.add((Component)spacer1, new GridConstraints(6, 1, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        this.headerLabel = new JLabel();
        this.$$$loadLabelText$$$(this.headerLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("TfsLoginForm.Header"));
        this.contentPanel.add((Component)this.headerLabel, new GridConstraints(0, 1, 1, 4, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("TfsLoginForm.ServerUrl"));
        this.contentPanel.add((Component)label1, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.serverUrl = new JTextField();
        this.contentPanel.add((Component)this.serverUrl, new GridConstraints(2, 2, 1, 3, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.exampleLabel = new JLabel();
        this.$$$loadLabelText$$$(this.exampleLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("TfsLoginForm.ExampleUrl"));
        this.contentPanel.add((Component)this.exampleLabel, new GridConstraints(3, 2, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        this.signInLink = new Hyperlink();
        this.$$$loadLabelText$$$((JLabel)((Object)this.signInLink), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("TfsLoginForm.Connect"));
        this.contentPanel.add((Component)((Object)this.signInLink), new GridConstraints(4, 2, 1, 3, 8, 0, 3, 3, null, null, null, 0, false));
        this.contentPanel.add((Component)this.vsIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.loginProgressLabel = new JLabel();
        this.loginProgressLabel.setText("Sample Text for Busy Spinner Message");
        this.contentPanel.add((Component)this.loginProgressLabel, new GridConstraints(5, 3, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.busySpinner = new BusySpinnerPanel();
        this.contentPanel.add((Component)this.busySpinner, new GridConstraints(5, 2, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.contentPanel.add((Component)spacer2, new GridConstraints(5, 4, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.descriptionLabel = new WrappingLabel();
        this.descriptionLabel.setText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("TfsLoginForm.Description"));
        this.contentPanel.add((Component)this.descriptionLabel, new GridConstraints(1, 1, 1, 4, 0, 3, 3, 3, null, null, null, 0, false));
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }
}

