/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common.forms;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.LoginForm;
import com.microsoft.alm.plugin.idea.common.ui.controls.BusySpinnerPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.Hyperlink;
import com.microsoft.alm.plugin.idea.common.ui.controls.IconPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.WrappingLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VsoLoginForm
implements LoginForm {
    private JPanel contentPanel;
    private IconPanel vsIcon;
    private Hyperlink createAnAccountLink;
    private Hyperlink signInLink;
    private BusySpinnerPanel busySpinnerPanel;
    private WrappingLabel descriptionLabel;
    private JLabel headerLabel;
    private JLabel loginProgressLabel;
    private Hyperlink learnMoreLink;
    private JLabel moreInfoLabel;
    private boolean initialized = false;

    public VsoLoginForm() {
        this.$$$setupUI$$$();
    }

    @Override
    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.contentPanel;
    }

    @Override
    public String getServerName() {
        return TfPluginBundle.message("UserAccountPanel.VSO.ServerName", new Object[0]);
    }

    @Override
    public void setServerName(String serverName) {
    }

    @Override
    public JComponent getServerNameComponent() {
        return null;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.signInLink.addActionListener(listener);
        this.createAnAccountLink.addActionListener(listener);
        this.learnMoreLink.addActionListener(listener);
    }

    @Override
    public void setAuthenticating(boolean inProgress) {
        if (inProgress) {
            this.busySpinnerPanel.start(true);
            this.loginProgressLabel.setText(TfPluginBundle.message("LoginForm.VSO.Authenticating", new Object[0]));
            this.signInLink.setEnabled(false);
        } else {
            this.busySpinnerPanel.stop(true);
            this.loginProgressLabel.setText("");
            this.signInLink.setEnabled(true);
        }
    }

    private void createUIComponents() {
        this.vsIcon = new IconPanel(Icons.VSLogo);
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.signInLink.setActionCommand("signIn");
            this.createAnAccountLink.setActionCommand("createAccount");
            this.learnMoreLink.setActionCommand("learnMore");
            this.setAuthenticating(false);
            this.headerLabel.setFont((Font)JBUI.Fonts.label((float)20.0f));
            this.signInLink.setFont((Font)JBUI.Fonts.label((float)16.0f));
            Dimension size = new Dimension(JBUI.scale((int)20), JBUI.scale((int)20));
            this.busySpinnerPanel.setPreferredSize(size);
            this.busySpinnerPanel.setMinimumSize(size);
            this.descriptionLabel.setMargin(new Insets(0, 0, JBUI.scale((int)15), 0));
            SwingHelper.setMargin((JComponent)this.moreInfoLabel, new Insets(JBUI.scale((int)20), 0, 0, 0));
            this.initialized = true;
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.signInLink;
    }

    @VisibleForTesting
    BusySpinnerPanel getBusySpinner() {
        return this.busySpinnerPanel;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.contentPanel.add((Component)spacer1, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.descriptionLabel = new WrappingLabel();
        this.descriptionLabel.setEnabled(true);
        this.descriptionLabel.setName("");
        this.descriptionLabel.setText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoLoginForm.Description"));
        this.contentPanel.add((Component)this.descriptionLabel, new GridConstraints(1, 1, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        this.headerLabel = new JLabel();
        this.$$$loadLabelText$$$(this.headerLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoLoginForm.Header"));
        this.contentPanel.add((Component)this.headerLabel, new GridConstraints(0, 1, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        this.contentPanel.add((Component)this.vsIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.busySpinnerPanel = new BusySpinnerPanel();
        this.contentPanel.add((Component)this.busySpinnerPanel, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.loginProgressLabel = new JLabel();
        this.loginProgressLabel.setText("Sample Text for Busy Spinner Message");
        this.contentPanel.add((Component)this.loginProgressLabel, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.contentPanel.add((Component)spacer2, new GridConstraints(3, 3, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.signInLink = new Hyperlink();
        this.$$$loadLabelText$$$((JLabel)((Object)this.signInLink), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoLoginForm.SignIn"));
        this.contentPanel.add((Component)((Object)this.signInLink), new GridConstraints(2, 1, 1, 3, 8, 0, 3, 3, null, null, null, 0, false));
        this.moreInfoLabel = new JLabel();
        this.$$$loadLabelText$$$(this.moreInfoLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("LoginForm.VSO.MoreInformationLabel"));
        this.contentPanel.add((Component)this.moreInfoLabel, new GridConstraints(4, 1, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        this.createAnAccountLink = new Hyperlink();
        this.$$$loadLabelText$$$((JLabel)((Object)this.createAnAccountLink), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoLoginForm.CreateAccount"));
        this.contentPanel.add((Component)((Object)this.createAnAccountLink), new GridConstraints(5, 1, 1, 3, 8, 0, 3, 3, null, null, null, 0, false));
        this.learnMoreLink = new Hyperlink();
        this.$$$loadLabelText$$$((JLabel)((Object)this.learnMoreLink), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoLoginForm.LearnMore"));
        this.contentPanel.add((Component)((Object)this.learnMoreLink), new GridConstraints(6, 1, 1, 3, 8, 0, 3, 3, null, null, null, 0, false));
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }
}

