/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common.tabs;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ActionListenerContainer;
import com.microsoft.alm.plugin.idea.common.ui.common.FeedbackAction;
import com.microsoft.alm.plugin.idea.common.ui.common.FilteredModel;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.ToolbarToggleButton;
import com.microsoft.alm.plugin.idea.common.ui.common.VcsTabStatus;
import com.microsoft.alm.plugin.idea.common.ui.common.tabs.TabForm;
import com.microsoft.alm.plugin.idea.common.ui.controls.Hyperlink;
import com.microsoft.alm.plugin.idea.common.ui.controls.SearchFilter;
import com.microsoft.alm.plugin.operations.Operation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public abstract class TabFormImpl<T extends FilteredModel>
implements TabForm<T> {
    private final String tabTitle;
    private final String createDialogTitle;
    private final String refreshTooltip;
    private final String toolbarLocation;
    private final ActionListenerContainer listenerContainer = new ActionListenerContainer();
    protected JPanel tabPanel;
    protected JScrollPane scrollPanel;
    protected JLabel statusLabel;
    protected Hyperlink statusLink;
    protected SearchFilter searchFilter;
    protected ToolbarToggleButton autoRefreshToggleButton;
    private boolean initialized = false;
    protected Timer timer;

    public TabFormImpl(String tabTitle, String createDialogTitle, String refreshTooltip, String toolbarLocation) {
        this.tabTitle = tabTitle;
        this.createDialogTitle = createDialogTitle;
        this.refreshTooltip = refreshTooltip;
        this.toolbarLocation = toolbarLocation;
    }

    @Override
    public JComponent getPanel() {
        this.ensureInitialized();
        return this.tabPanel;
    }

    protected abstract void createCustomView();

    protected abstract void addCustomTools(JPanel var1);

    @Override
    public abstract void setModelForView(T var1);

    protected void ensureInitialized() {
        if (!this.initialized) {
            JPanel toolBarPanel;
            this.createCustomView();
            this.createFilterToolbar();
            if (ApplicationManager.getApplication() != null) {
                ActionToolbar prActionsToolbar = this.createToolbar(this.createActionsGroup());
                ActionToolbar feedbackActionsToolbar = this.createToolbar(this.createFeedbackGroup());
                ActionToolbar optionsActionsToolbar = this.createToolbar(this.createOptionsGroup());
                FlowLayout flowLayout = new FlowLayout(0, 0, JBUI.scale((int)3));
                JPanel toolBarPanelLeft = new JPanel(flowLayout);
                toolBarPanelLeft.add(prActionsToolbar.getComponent());
                toolBarPanelLeft.add(this.searchFilter);
                this.addCustomTools(toolBarPanelLeft);
                FlowLayout flowLayout2 = new FlowLayout(0, 0, JBUI.scale((int)3));
                JPanel toolBarPanelMiddle = new JPanel(flowLayout2);
                toolBarPanelMiddle.add(optionsActionsToolbar.getComponent());
                SwingHelper.setMargin((JComponent)toolBarPanelMiddle, new Insets(JBUI.scale((int)2), JBUI.scale((int)15), 0, 0));
                toolBarPanel = new JPanel(new BorderLayout());
                toolBarPanel.add((Component)toolBarPanelLeft, "Before");
                toolBarPanel.add((Component)toolBarPanelMiddle, "Center");
                toolBarPanel.add((Component)feedbackActionsToolbar.getComponent(), "After");
            } else {
                toolBarPanel = new JPanel();
            }
            JPanel statusPanel = new JPanel(new FlowLayout(0));
            this.statusLabel = new JLabel();
            this.statusLink = new Hyperlink();
            this.statusLink.setActionCommand("statusLink");
            statusPanel.add(this.statusLabel);
            statusPanel.add((Component)((Object)this.statusLink));
            this.tabPanel = new JPanel(new BorderLayout());
            this.tabPanel.add((Component)toolBarPanel, "First");
            this.tabPanel.add((Component)this.scrollPanel, "Center");
            this.tabPanel.add((Component)statusPanel, "Last");
            this.initialized = true;
        }
    }

    protected ActionToolbar createToolbar(DefaultActionGroup actions) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(this.toolbarLocation, (ActionGroup)actions, false);
        toolbar.setOrientation(0);
        toolbar.setTargetComponent((JComponent)this.scrollPanel);
        return toolbar;
    }

    protected DefaultActionGroup createActionsGroup() {
        AnAction createAction = new AnAction(TfPluginBundle.message(this.createDialogTitle, new Object[0]), TfPluginBundle.message(this.createDialogTitle, new Object[0]), AllIcons.ToolbarDecorator.Add){

            public void actionPerformed(AnActionEvent anActionEvent) {
                TabFormImpl.this.listenerContainer.triggerEvent((Object)this, "createNewItemLink");
            }
        };
        createAction.registerCustomShortcutSet(CommonShortcuts.getNew(), (JComponent)this.scrollPanel);
        AnAction refreshAction = new AnAction(TfPluginBundle.message(this.refreshTooltip, new Object[0]), TfPluginBundle.message(this.refreshTooltip, new Object[0]), AllIcons.Actions.Refresh){

            public void actionPerformed(AnActionEvent anActionEvent) {
                TabFormImpl.this.listenerContainer.triggerEvent((Object)this, "refresh");
            }
        };
        refreshAction.registerCustomShortcutSet(CommonShortcuts.getRerun(), (JComponent)this.scrollPanel);
        return new DefaultActionGroup(new AnAction[]{createAction, refreshAction});
    }

    protected DefaultActionGroup createOptionsGroup() {
        this.autoRefreshToggleButton = new ToolbarToggleButton(TfPluginBundle.message("VcsTab.AutoRefresh", new Object[0]), true, "autoRefreshChanged");
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)this.autoRefreshToggleButton);
        return group;
    }

    protected DefaultActionGroup createFeedbackGroup() {
        AnAction sendFeedback = new AnAction(TfPluginBundle.message("Feedback.Dialog.Title", new Object[0]), TfPluginBundle.message("Feedback.Dialog.Title", new Object[0]), Icons.Smile){

            public void actionPerformed(AnActionEvent anActionEvent) {
                FeedbackAction action = new FeedbackAction(anActionEvent.getProject(), TfPluginBundle.message(TabFormImpl.this.tabTitle, new Object[0]));
                action.actionPerformed(new ActionEvent(anActionEvent.getInputEvent().getSource(), anActionEvent.getInputEvent().getID(), "sendFeedback"));
            }
        };
        return new DefaultActionGroup(new AnAction[]{sendFeedback});
    }

    protected void createFilterToolbar() {
        this.timer = new Timer(400, null);
        this.timer.setInitialDelay(400);
        this.timer.setActionCommand("filter");
        this.timer.setRepeats(false);
        this.searchFilter = new SearchFilter();
        this.searchFilter.setFilterText("");
    }

    @Override
    public void setStatus(VcsTabStatus status) {
        switch (status) {
            case NOT_TF_GIT_REPO: {
                this.statusLabel.setText(TfPluginBundle.message("Errors.NotTfsRepo", TfPluginBundle.message(this.tabTitle, new Object[0]).toLowerCase()));
                this.statusLabel.setIcon(AllIcons.General.Error);
                this.statusLink.setText(TfPluginBundle.message("ImportDialog.Title", new Object[0]));
                this.statusLink.setVisible(true);
                break;
            }
            case NO_AUTH_INFO: {
                this.statusLabel.setText(TfPluginBundle.message("VcsTab.NoAuthenticated", new Object[0]));
                this.statusLabel.setIcon(AllIcons.General.Error);
                this.statusLink.setText(TfPluginBundle.message("VcsTab.SignIn", new Object[0]));
                this.statusLink.setVisible(true);
                break;
            }
            case LOADING_IN_PROGRESS: {
                this.statusLabel.setText(TfPluginBundle.message("VcsTab.Loading", new Object[0]));
                this.statusLabel.setIcon(AllIcons.General.Information);
                this.statusLink.setText("");
                this.statusLink.setVisible(false);
                break;
            }
            case LOADING_COMPLETED_ERRORS: {
                this.statusLabel.setText(TfPluginBundle.message("VcsTab.LoadingErrors", TfPluginBundle.message(this.tabTitle, new Object[0]).toLowerCase()));
                this.statusLabel.setIcon(AllIcons.General.Warning);
                this.statusLink.setText(TfPluginBundle.message("VcsTab.OpenInBrowser", new Object[0]));
                this.statusLink.setVisible(true);
                break;
            }
            case LOADING_COMPLETED: {
                this.statusLabel.setText(TfPluginBundle.message("VcsTab.LastRefreshedAt", new Date().toString()));
                this.statusLabel.setIcon(AllIcons.General.Information);
                this.statusLink.setText(TfPluginBundle.message("VcsTab.OpenInBrowser", new Object[0]));
                this.statusLink.setVisible(true);
                break;
            }
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.timer.addActionListener(listener);
        this.statusLink.addActionListener(listener);
        this.autoRefreshToggleButton.addActionListener(listener);
        this.listenerContainer.add(listener);
    }

    protected void triggerEvent(String event) {
        this.listenerContainer.triggerEvent(this, event);
    }

    protected void showPopupMenu(Component component, int x, int y, ActionListener listener) {
        JBPopupMenu menu = new JBPopupMenu();
        List<JBMenuItem> openMenuItems = this.getMenuItems(listener);
        for (JBMenuItem menuItem : openMenuItems) {
            menu.add((JMenuItem)menuItem);
        }
        menu.show(component, x, y);
    }

    protected abstract List<JBMenuItem> getMenuItems(ActionListener var1);

    protected JBMenuItem createMenuItem(String resourceKey, Icon icon, String actionCommand, ActionListener listener) {
        String text = TfPluginBundle.message(resourceKey, new Object[0]);
        JBMenuItem menuItem = new JBMenuItem(text, icon);
        menuItem.setActionCommand(actionCommand);
        menuItem.addActionListener(listener);
        return menuItem;
    }

    @Override
    public void setFilter(String filterString) {
        this.searchFilter.setFilterText(filterString);
    }

    @Override
    public String getFilter() {
        return this.searchFilter.getFilterText();
    }

    @Override
    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefreshToggleButton.setSelected(null, autoRefresh);
    }

    @Override
    public boolean getAutoRefresh() {
        return this.autoRefreshToggleButton.isSelected(null);
    }

    @Override
    public abstract Operation.CredInputsImpl getOperationInputs();

    @Override
    public abstract void refresh(boolean var1);

    @VisibleForTesting
    String getStatusText() {
        return this.statusLabel.getText();
    }

    @VisibleForTesting
    String getStatusLinkText() {
        return this.statusLink.getText();
    }
}

